package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenewNetworkPackages invokes the ecd.RenewNetworkPackages API synchronously
func (client *Client) RenewNetworkPackages(request *RenewNetworkPackagesRequest) (response *RenewNetworkPackagesResponse, err error) {
	response = CreateRenewNetworkPackagesResponse()
	err = client.DoAction(request, response)
	return
}

// RenewNetworkPackagesWithChan invokes the ecd.RenewNetworkPackages API asynchronously
func (client *Client) RenewNetworkPackagesWithChan(request *RenewNetworkPackagesRequest) (<-chan *RenewNetworkPackagesResponse, <-chan error) {
	responseChan := make(chan *RenewNetworkPackagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenewNetworkPackages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenewNetworkPackagesWithCallback invokes the ecd.RenewNetworkPackages API asynchronously
func (client *Client) RenewNetworkPackagesWithCallback(request *RenewNetworkPackagesRequest, callback func(response *RenewNetworkPackagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenewNetworkPackagesResponse
		var err error
		defer close(result)
		response, err = client.RenewNetworkPackages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenewNetworkPackagesRequest is the request struct for api RenewNetworkPackages
type RenewNetworkPackagesRequest struct {
	*requests.RpcRequest
	Period           requests.Integer `position:"Query" name:"Period"`
	AutoPay          requests.Boolean `position:"Query" name:"AutoPay"`
	NetworkPackageId *[]string        `position:"Query" name:"NetworkPackageId"  type:"Repeated"`
	PromotionId      string           `position:"Query" name:"PromotionId"`
	PeriodUnit       string           `position:"Query" name:"PeriodUnit"`
}

// RenewNetworkPackagesResponse is the response struct for api RenewNetworkPackages
type RenewNetworkPackagesResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRenewNetworkPackagesRequest creates a request to invoke RenewNetworkPackages API
func CreateRenewNetworkPackagesRequest() (request *RenewNetworkPackagesRequest) {
	request = &RenewNetworkPackagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RenewNetworkPackages", "", "")
	request.Method = requests.POST
	return
}

// CreateRenewNetworkPackagesResponse creates a response to parse from RenewNetworkPackages response
func CreateRenewNetworkPackagesResponse() (response *RenewNetworkPackagesResponse) {
	response = &RenewNetworkPackagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
