package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RollbackSuspEventQuaraFile invokes the ecd.RollbackSuspEventQuaraFile API synchronously
func (client *Client) RollbackSuspEventQuaraFile(request *RollbackSuspEventQuaraFileRequest) (response *RollbackSuspEventQuaraFileResponse, err error) {
	response = CreateRollbackSuspEventQuaraFileResponse()
	err = client.DoAction(request, response)
	return
}

// RollbackSuspEventQuaraFileWithChan invokes the ecd.RollbackSuspEventQuaraFile API asynchronously
func (client *Client) RollbackSuspEventQuaraFileWithChan(request *RollbackSuspEventQuaraFileRequest) (<-chan *RollbackSuspEventQuaraFileResponse, <-chan error) {
	responseChan := make(chan *RollbackSuspEventQuaraFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RollbackSuspEventQuaraFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RollbackSuspEventQuaraFileWithCallback invokes the ecd.RollbackSuspEventQuaraFile API asynchronously
func (client *Client) RollbackSuspEventQuaraFileWithCallback(request *RollbackSuspEventQuaraFileRequest, callback func(response *RollbackSuspEventQuaraFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RollbackSuspEventQuaraFileResponse
		var err error
		defer close(result)
		response, err = client.RollbackSuspEventQuaraFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RollbackSuspEventQuaraFileRequest is the request struct for api RollbackSuspEventQuaraFile
type RollbackSuspEventQuaraFileRequest struct {
	*requests.RpcRequest
	QuaraFieldId requests.Integer `position:"Query" name:"QuaraFieldId"`
	DesktopId    string           `position:"Query" name:"DesktopId"`
}

// RollbackSuspEventQuaraFileResponse is the response struct for api RollbackSuspEventQuaraFile
type RollbackSuspEventQuaraFileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRollbackSuspEventQuaraFileRequest creates a request to invoke RollbackSuspEventQuaraFile API
func CreateRollbackSuspEventQuaraFileRequest() (request *RollbackSuspEventQuaraFileRequest) {
	request = &RollbackSuspEventQuaraFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "RollbackSuspEventQuaraFile", "", "")
	request.Method = requests.POST
	return
}

// CreateRollbackSuspEventQuaraFileResponse creates a response to parse from RollbackSuspEventQuaraFile response
func CreateRollbackSuspEventQuaraFileResponse() (response *RollbackSuspEventQuaraFileResponse) {
	response = &RollbackSuspEventQuaraFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
