package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceProvidersPage invokes the edas.GetServiceProvidersPage API synchronously
func (client *Client) GetServiceProvidersPage(request *GetServiceProvidersPageRequest) (response *GetServiceProvidersPageResponse, err error) {
	response = CreateGetServiceProvidersPageResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceProvidersPageWithChan invokes the edas.GetServiceProvidersPage API asynchronously
func (client *Client) GetServiceProvidersPageWithChan(request *GetServiceProvidersPageRequest) (<-chan *GetServiceProvidersPageResponse, <-chan error) {
	responseChan := make(chan *GetServiceProvidersPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceProvidersPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceProvidersPageWithCallback invokes the edas.GetServiceProvidersPage API asynchronously
func (client *Client) GetServiceProvidersPageWithCallback(request *GetServiceProvidersPageRequest, callback func(response *GetServiceProvidersPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceProvidersPageResponse
		var err error
		defer close(result)
		response, err = client.GetServiceProvidersPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceProvidersPageRequest is the request struct for api GetServiceProvidersPage
type GetServiceProvidersPageRequest struct {
	*requests.RoaRequest
	RegistryType   string `position:"Query" name:"registryType"`
	Origin         string `position:"Query" name:"origin"`
	Ip             string `position:"Query" name:"ip"`
	Source         string `position:"Query" name:"source"`
	ServiceType    string `position:"Query" name:"serviceType"`
	Size           string `position:"Query" name:"size"`
	AppId          string `position:"Query" name:"appId"`
	Namespace      string `position:"Query" name:"namespace"`
	ServiceVersion string `position:"Query" name:"serviceVersion"`
	ServiceName    string `position:"Query" name:"serviceName"`
	Page           string `position:"Query" name:"page"`
	Region         string `position:"Query" name:"region"`
	ServiceId      string `position:"Query" name:"serviceId"`
	Group          string `position:"Query" name:"group"`
}

// GetServiceProvidersPageResponse is the response struct for api GetServiceProvidersPage
type GetServiceProvidersPageResponse struct {
	*responses.BaseResponse
	Code    int    `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
	Success bool   `json:"Success" xml:"Success"`
	Data    Data   `json:"Data" xml:"Data"`
}

// CreateGetServiceProvidersPageRequest creates a request to invoke GetServiceProvidersPage API
func CreateGetServiceProvidersPageRequest() (request *GetServiceProvidersPageRequest) {
	request = &GetServiceProvidersPageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetServiceProvidersPage", "/pop/sp/api/mseForOam/getServiceProvidersPage", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceProvidersPageResponse creates a response to parse from GetServiceProvidersPage response
func CreateGetServiceProvidersPageResponse() (response *GetServiceProvidersPageResponse) {
	response = &GetServiceProvidersPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
