package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateContainer invokes the edas.UpdateContainer API synchronously
func (client *Client) UpdateContainer(request *UpdateContainerRequest) (response *UpdateContainerResponse, err error) {
	response = CreateUpdateContainerResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateContainerWithChan invokes the edas.UpdateContainer API asynchronously
func (client *Client) UpdateContainerWithChan(request *UpdateContainerRequest) (<-chan *UpdateContainerResponse, <-chan error) {
	responseChan := make(chan *UpdateContainerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateContainer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateContainerWithCallback invokes the edas.UpdateContainer API asynchronously
func (client *Client) UpdateContainerWithCallback(request *UpdateContainerRequest, callback func(response *UpdateContainerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateContainerResponse
		var err error
		defer close(result)
		response, err = client.UpdateContainer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateContainerRequest is the request struct for api UpdateContainer
type UpdateContainerRequest struct {
	*requests.RoaRequest
	BuildPackId string `position:"Query" name:"BuildPackId"`
	AppId       string `position:"Query" name:"AppId"`
}

// UpdateContainerResponse is the response struct for api UpdateContainer
type UpdateContainerResponse struct {
	*responses.BaseResponse
	Code          int    `json:"Code" xml:"Code"`
	ChangeOrderId string `json:"ChangeOrderId" xml:"ChangeOrderId"`
	Message       string `json:"Message" xml:"Message"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateContainerRequest creates a request to invoke UpdateContainer API
func CreateUpdateContainerRequest() (request *UpdateContainerRequest) {
	request = &UpdateContainerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "UpdateContainer", "/pop/v5/changeorder/co_update_container", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateContainerResponse creates a response to parse from UpdateContainer response
func CreateUpdateContainerResponse() (response *UpdateContainerResponse) {
	response = &UpdateContainerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
