package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListUsersAsync invokes the ehpc.ListUsersAsync API synchronously
func (client *Client) ListUsersAsync(request *ListUsersAsyncRequest) (response *ListUsersAsyncResponse, err error) {
	response = CreateListUsersAsyncResponse()
	err = client.DoAction(request, response)
	return
}

// ListUsersAsyncWithChan invokes the ehpc.ListUsersAsync API asynchronously
func (client *Client) ListUsersAsyncWithChan(request *ListUsersAsyncRequest) (<-chan *ListUsersAsyncResponse, <-chan error) {
	responseChan := make(chan *ListUsersAsyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListUsersAsync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListUsersAsyncWithCallback invokes the ehpc.ListUsersAsync API asynchronously
func (client *Client) ListUsersAsyncWithCallback(request *ListUsersAsyncRequest, callback func(response *ListUsersAsyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListUsersAsyncResponse
		var err error
		defer close(result)
		response, err = client.ListUsersAsync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListUsersAsyncRequest is the request struct for api ListUsersAsync
type ListUsersAsyncRequest struct {
	*requests.RpcRequest
	AsyncId    string           `position:"Query" name:"AsyncId"`
	ClusterId  string           `position:"Query" name:"ClusterId"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListUsersAsyncResponse is the response struct for api ListUsersAsync
type ListUsersAsyncResponse struct {
	*responses.BaseResponse
	PageSize    int                   `json:"PageSize" xml:"PageSize"`
	RequestId   string                `json:"RequestId" xml:"RequestId"`
	PageNumber  int                   `json:"PageNumber" xml:"PageNumber"`
	TotalCount  int                   `json:"TotalCount" xml:"TotalCount"`
	AsyncId     string                `json:"AsyncId" xml:"AsyncId"`
	AsyncStatus string                `json:"AsyncStatus" xml:"AsyncStatus"`
	Users       UsersInListUsersAsync `json:"Users" xml:"Users"`
}

// CreateListUsersAsyncRequest creates a request to invoke ListUsersAsync API
func CreateListUsersAsyncRequest() (request *ListUsersAsyncRequest) {
	request = &ListUsersAsyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "ListUsersAsync", "", "")
	request.Method = requests.GET
	return
}

// CreateListUsersAsyncResponse creates a response to parse from ListUsersAsync response
func CreateListUsersAsyncResponse() (response *ListUsersAsyncResponse) {
	response = &ListUsersAsyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
