package emas_appmonitor

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPagePerfTrendGroupByPageName invokes the emas_appmonitor.QueryPagePerfTrendGroupByPageName API synchronously
func (client *Client) QueryPagePerfTrendGroupByPageName(request *QueryPagePerfTrendGroupByPageNameRequest) (response *QueryPagePerfTrendGroupByPageNameResponse, err error) {
	response = CreateQueryPagePerfTrendGroupByPageNameResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPagePerfTrendGroupByPageNameWithChan invokes the emas_appmonitor.QueryPagePerfTrendGroupByPageName API asynchronously
func (client *Client) QueryPagePerfTrendGroupByPageNameWithChan(request *QueryPagePerfTrendGroupByPageNameRequest) (<-chan *QueryPagePerfTrendGroupByPageNameResponse, <-chan error) {
	responseChan := make(chan *QueryPagePerfTrendGroupByPageNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPagePerfTrendGroupByPageName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPagePerfTrendGroupByPageNameWithCallback invokes the emas_appmonitor.QueryPagePerfTrendGroupByPageName API asynchronously
func (client *Client) QueryPagePerfTrendGroupByPageNameWithCallback(request *QueryPagePerfTrendGroupByPageNameRequest, callback func(response *QueryPagePerfTrendGroupByPageNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPagePerfTrendGroupByPageNameResponse
		var err error
		defer close(result)
		response, err = client.QueryPagePerfTrendGroupByPageName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPagePerfTrendGroupByPageNameRequest is the request struct for api QueryPagePerfTrendGroupByPageName
type QueryPagePerfTrendGroupByPageNameRequest struct {
	*requests.RpcRequest
	MetricType         string           `position:"Body" name:"MetricType"`
	AppVersionStrategy string           `position:"Body" name:"AppVersionStrategy"`
	StartTime          requests.Integer `position:"Body" name:"StartTime"`
	DeviceLevel        string           `position:"Body" name:"DeviceLevel"`
	Province           *[]string        `position:"Body" name:"Province"  type:"Repeated"`
	StatType           string           `position:"Body" name:"StatType"`
	IntervalMinutes    requests.Integer `position:"Body" name:"IntervalMinutes"`
	UniqueAppId        string           `position:"Body" name:"UniqueAppId"`
	GroupByPageName    requests.Boolean `position:"Body" name:"GroupByPageName"`
	EndTime            requests.Integer `position:"Body" name:"EndTime"`
	AppVersion         *[]string        `position:"Body" name:"AppVersion"  type:"Repeated"`
}

// QueryPagePerfTrendGroupByPageNameResponse is the response struct for api QueryPagePerfTrendGroupByPageName
type QueryPagePerfTrendGroupByPageNameResponse struct {
	*responses.BaseResponse
	RequestId        string             `json:"RequestId" xml:"RequestId"`
	MetricResultList []MetricResultItem `json:"MetricResultList" xml:"MetricResultList"`
}

// CreateQueryPagePerfTrendGroupByPageNameRequest creates a request to invoke QueryPagePerfTrendGroupByPageName API
func CreateQueryPagePerfTrendGroupByPageNameRequest() (request *QueryPagePerfTrendGroupByPageNameRequest) {
	request = &QueryPagePerfTrendGroupByPageNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("emas-appmonitor", "2019-06-11", "QueryPagePerfTrendGroupByPageName", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryPagePerfTrendGroupByPageNameResponse creates a response to parse from QueryPagePerfTrendGroupByPageName response
func CreateQueryPagePerfTrendGroupByPageNameResponse() (response *QueryPagePerfTrendGroupByPageNameResponse) {
	response = &QueryPagePerfTrendGroupByPageNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
