package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFlowInstance invokes the emr.DescribeFlowInstance API synchronously
func (client *Client) DescribeFlowInstance(request *DescribeFlowInstanceRequest) (response *DescribeFlowInstanceResponse, err error) {
	response = CreateDescribeFlowInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFlowInstanceWithChan invokes the emr.DescribeFlowInstance API asynchronously
func (client *Client) DescribeFlowInstanceWithChan(request *DescribeFlowInstanceRequest) (<-chan *DescribeFlowInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeFlowInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFlowInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFlowInstanceWithCallback invokes the emr.DescribeFlowInstance API asynchronously
func (client *Client) DescribeFlowInstanceWithCallback(request *DescribeFlowInstanceRequest, callback func(response *DescribeFlowInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFlowInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeFlowInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFlowInstanceRequest is the request struct for api DescribeFlowInstance
type DescribeFlowInstanceRequest struct {
	*requests.RpcRequest
	Id        string `position:"Query" name:"Id"`
	ProjectId string `position:"Query" name:"ProjectId"`
}

// DescribeFlowInstanceResponse is the response struct for api DescribeFlowInstance
type DescribeFlowInstanceResponse struct {
	*responses.BaseResponse
	RequestId          string                             `json:"RequestId" xml:"RequestId"`
	Id                 string                             `json:"Id" xml:"Id"`
	GmtCreate          int64                              `json:"GmtCreate" xml:"GmtCreate"`
	GmtModified        int64                              `json:"GmtModified" xml:"GmtModified"`
	FlowId             string                             `json:"FlowId" xml:"FlowId"`
	FlowName           string                             `json:"FlowName" xml:"FlowName"`
	ProjectId          string                             `json:"ProjectId" xml:"ProjectId"`
	Status             string                             `json:"Status" xml:"Status"`
	ClusterId          string                             `json:"ClusterId" xml:"ClusterId"`
	Namespace          string                             `json:"Namespace" xml:"Namespace"`
	LogArchiveLocation string                             `json:"LogArchiveLocation" xml:"LogArchiveLocation"`
	Lifecycle          string                             `json:"Lifecycle" xml:"Lifecycle"`
	StartTime          int64                              `json:"StartTime" xml:"StartTime"`
	EndTime            int64                              `json:"EndTime" xml:"EndTime"`
	Duration           int64                              `json:"Duration" xml:"Duration"`
	ScheduleTime       int64                              `json:"ScheduleTime" xml:"ScheduleTime"`
	Graph              string                             `json:"Graph" xml:"Graph"`
	CronExpression     string                             `json:"CronExpression" xml:"CronExpression"`
	HasNodeFailed      bool                               `json:"HasNodeFailed" xml:"HasNodeFailed"`
	DependencyFlowList DependencyFlowList                 `json:"DependencyFlowList" xml:"DependencyFlowList"`
	NodeInstance       NodeInstanceInDescribeFlowInstance `json:"NodeInstance" xml:"NodeInstance"`
}

// CreateDescribeFlowInstanceRequest creates a request to invoke DescribeFlowInstance API
func CreateDescribeFlowInstanceRequest() (request *DescribeFlowInstanceRequest) {
	request = &DescribeFlowInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeFlowInstance", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFlowInstanceResponse creates a response to parse from DescribeFlowInstance response
func CreateDescribeFlowInstanceResponse() (response *DescribeFlowInstanceResponse) {
	response = &DescribeFlowInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
