package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveVSwitchesFromEpnInstance invokes the ens.RemoveVSwitchesFromEpnInstance API synchronously
func (client *Client) RemoveVSwitchesFromEpnInstance(request *RemoveVSwitchesFromEpnInstanceRequest) (response *RemoveVSwitchesFromEpnInstanceResponse, err error) {
	response = CreateRemoveVSwitchesFromEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveVSwitchesFromEpnInstanceWithChan invokes the ens.RemoveVSwitchesFromEpnInstance API asynchronously
func (client *Client) RemoveVSwitchesFromEpnInstanceWithChan(request *RemoveVSwitchesFromEpnInstanceRequest) (<-chan *RemoveVSwitchesFromEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *RemoveVSwitchesFromEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveVSwitchesFromEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveVSwitchesFromEpnInstanceWithCallback invokes the ens.RemoveVSwitchesFromEpnInstance API asynchronously
func (client *Client) RemoveVSwitchesFromEpnInstanceWithCallback(request *RemoveVSwitchesFromEpnInstanceRequest, callback func(response *RemoveVSwitchesFromEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveVSwitchesFromEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.RemoveVSwitchesFromEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveVSwitchesFromEpnInstanceRequest is the request struct for api RemoveVSwitchesFromEpnInstance
type RemoveVSwitchesFromEpnInstanceRequest struct {
	*requests.RpcRequest
	VSwitchesInfo string `position:"Query" name:"VSwitchesInfo"`
	EPNInstanceId string `position:"Query" name:"EPNInstanceId"`
}

// RemoveVSwitchesFromEpnInstanceResponse is the response struct for api RemoveVSwitchesFromEpnInstance
type RemoveVSwitchesFromEpnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemoveVSwitchesFromEpnInstanceRequest creates a request to invoke RemoveVSwitchesFromEpnInstance API
func CreateRemoveVSwitchesFromEpnInstanceRequest() (request *RemoveVSwitchesFromEpnInstanceRequest) {
	request = &RemoveVSwitchesFromEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "RemoveVSwitchesFromEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveVSwitchesFromEpnInstanceResponse creates a response to parse from RemoveVSwitchesFromEpnInstance response
func CreateRemoveVSwitchesFromEpnInstanceResponse() (response *RemoveVSwitchesFromEpnInstanceResponse) {
	response = &RemoveVSwitchesFromEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
