package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CompareFaceWithMask invokes the facebody.CompareFaceWithMask API synchronously
func (client *Client) CompareFaceWithMask(request *CompareFaceWithMaskRequest) (response *CompareFaceWithMaskResponse, err error) {
	response = CreateCompareFaceWithMaskResponse()
	err = client.DoAction(request, response)
	return
}

// CompareFaceWithMaskWithChan invokes the facebody.CompareFaceWithMask API asynchronously
func (client *Client) CompareFaceWithMaskWithChan(request *CompareFaceWithMaskRequest) (<-chan *CompareFaceWithMaskResponse, <-chan error) {
	responseChan := make(chan *CompareFaceWithMaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CompareFaceWithMask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CompareFaceWithMaskWithCallback invokes the facebody.CompareFaceWithMask API asynchronously
func (client *Client) CompareFaceWithMaskWithCallback(request *CompareFaceWithMaskRequest, callback func(response *CompareFaceWithMaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CompareFaceWithMaskResponse
		var err error
		defer close(result)
		response, err = client.CompareFaceWithMask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CompareFaceWithMaskRequest is the request struct for api CompareFaceWithMask
type CompareFaceWithMaskRequest struct {
	*requests.RpcRequest
	FormatResultToJson    requests.Boolean `position:"Query" name:"FormatResultToJson"`
	QualityScoreThreshold requests.Float   `position:"Body" name:"QualityScoreThreshold"`
	ImageURLB             string           `position:"Body" name:"ImageURLB"`
	ImageURLA             string           `position:"Body" name:"ImageURLA"`
	OssFile               string           `position:"Query" name:"OssFile"`
	RequestProxyBy        string           `position:"Query" name:"RequestProxyBy"`
}

// CompareFaceWithMaskResponse is the response struct for api CompareFaceWithMask
type CompareFaceWithMaskResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Code      string                    `json:"Code" xml:"Code"`
	Message   string                    `json:"Message" xml:"Message"`
	Data      DataInCompareFaceWithMask `json:"Data" xml:"Data"`
}

// CreateCompareFaceWithMaskRequest creates a request to invoke CompareFaceWithMask API
func CreateCompareFaceWithMaskRequest() (request *CompareFaceWithMaskRequest) {
	request = &CompareFaceWithMaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "CompareFaceWithMask", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCompareFaceWithMaskResponse creates a response to parse from CompareFaceWithMask response
func CreateCompareFaceWithMaskResponse() (response *CompareFaceWithMaskResponse) {
	response = &CompareFaceWithMaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
