package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeExpression invokes the facebody.RecognizeExpression API synchronously
func (client *Client) RecognizeExpression(request *RecognizeExpressionRequest) (response *RecognizeExpressionResponse, err error) {
	response = CreateRecognizeExpressionResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeExpressionWithChan invokes the facebody.RecognizeExpression API asynchronously
func (client *Client) RecognizeExpressionWithChan(request *RecognizeExpressionRequest) (<-chan *RecognizeExpressionResponse, <-chan error) {
	responseChan := make(chan *RecognizeExpressionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeExpression(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeExpressionWithCallback invokes the facebody.RecognizeExpression API asynchronously
func (client *Client) RecognizeExpressionWithCallback(request *RecognizeExpressionRequest, callback func(response *RecognizeExpressionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeExpressionResponse
		var err error
		defer close(result)
		response, err = client.RecognizeExpression(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeExpressionRequest is the request struct for api RecognizeExpression
type RecognizeExpressionRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean `position:"Query" name:"FormatResultToJson"`
	OssFile            string           `position:"Query" name:"OssFile"`
	RequestProxyBy     string           `position:"Query" name:"RequestProxyBy"`
	ImageURL           string           `position:"Body" name:"ImageURL"`
}

// RecognizeExpressionResponse is the response struct for api RecognizeExpression
type RecognizeExpressionResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Data      DataInRecognizeExpression `json:"Data" xml:"Data"`
}

// CreateRecognizeExpressionRequest creates a request to invoke RecognizeExpression API
func CreateRecognizeExpressionRequest() (request *RecognizeExpressionRequest) {
	request = &RecognizeExpressionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "RecognizeExpression", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizeExpressionResponse creates a response to parse from RecognizeExpression response
func CreateRecognizeExpressionResponse() (response *RecognizeExpressionResponse) {
	response = &RecognizeExpressionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
