package imagerecog

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeLogo invokes the imagerecog.RecognizeLogo API synchronously
func (client *Client) RecognizeLogo(request *RecognizeLogoRequest) (response *RecognizeLogoResponse, err error) {
	response = CreateRecognizeLogoResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeLogoWithChan invokes the imagerecog.RecognizeLogo API asynchronously
func (client *Client) RecognizeLogoWithChan(request *RecognizeLogoRequest) (<-chan *RecognizeLogoResponse, <-chan error) {
	responseChan := make(chan *RecognizeLogoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeLogo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeLogoWithCallback invokes the imagerecog.RecognizeLogo API asynchronously
func (client *Client) RecognizeLogoWithCallback(request *RecognizeLogoRequest, callback func(response *RecognizeLogoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeLogoResponse
		var err error
		defer close(result)
		response, err = client.RecognizeLogo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeLogoRequest is the request struct for api RecognizeLogo
type RecognizeLogoRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean      `position:"Query" name:"FormatResultToJson"`
	OssFile            string                `position:"Query" name:"OssFile"`
	Tasks              *[]RecognizeLogoTasks `position:"Body" name:"Tasks"  type:"Repeated"`
	RequestProxyBy     string                `position:"Query" name:"RequestProxyBy"`
}

// RecognizeLogoTasks is a repeated param struct in RecognizeLogoRequest
type RecognizeLogoTasks struct {
	ImageURL string `name:"ImageURL"`
}

// RecognizeLogoResponse is the response struct for api RecognizeLogo
type RecognizeLogoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizeLogoRequest creates a request to invoke RecognizeLogo API
func CreateRecognizeLogoRequest() (request *RecognizeLogoRequest) {
	request = &RecognizeLogoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imagerecog", "2019-09-30", "RecognizeLogo", "", "")
	request.Method = requests.POST
	return
}

// CreateRecognizeLogoResponse creates a response to parse from RecognizeLogo response
func CreateRecognizeLogoResponse() (response *RecognizeLogoResponse) {
	response = &RecognizeLogoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
