package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchCreateSoundCodeLabel invokes the iot.BatchCreateSoundCodeLabel API synchronously
func (client *Client) BatchCreateSoundCodeLabel(request *BatchCreateSoundCodeLabelRequest) (response *BatchCreateSoundCodeLabelResponse, err error) {
	response = CreateBatchCreateSoundCodeLabelResponse()
	err = client.DoAction(request, response)
	return
}

// BatchCreateSoundCodeLabelWithChan invokes the iot.BatchCreateSoundCodeLabel API asynchronously
func (client *Client) BatchCreateSoundCodeLabelWithChan(request *BatchCreateSoundCodeLabelRequest) (<-chan *BatchCreateSoundCodeLabelResponse, <-chan error) {
	responseChan := make(chan *BatchCreateSoundCodeLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchCreateSoundCodeLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchCreateSoundCodeLabelWithCallback invokes the iot.BatchCreateSoundCodeLabel API asynchronously
func (client *Client) BatchCreateSoundCodeLabelWithCallback(request *BatchCreateSoundCodeLabelRequest, callback func(response *BatchCreateSoundCodeLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchCreateSoundCodeLabelResponse
		var err error
		defer close(result)
		response, err = client.BatchCreateSoundCodeLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchCreateSoundCodeLabelRequest is the request struct for api BatchCreateSoundCodeLabel
type BatchCreateSoundCodeLabelRequest struct {
	*requests.RpcRequest
	ScheduleCode  string           `position:"Body" name:"ScheduleCode"`
	Description   string           `position:"Body" name:"Description"`
	Total         requests.Integer `position:"Body" name:"Total"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// BatchCreateSoundCodeLabelResponse is the response struct for api BatchCreateSoundCodeLabel
type BatchCreateSoundCodeLabelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateBatchCreateSoundCodeLabelRequest creates a request to invoke BatchCreateSoundCodeLabel API
func CreateBatchCreateSoundCodeLabelRequest() (request *BatchCreateSoundCodeLabelRequest) {
	request = &BatchCreateSoundCodeLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchCreateSoundCodeLabel", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchCreateSoundCodeLabelResponse creates a response to parse from BatchCreateSoundCodeLabel response
func CreateBatchCreateSoundCodeLabelResponse() (response *BatchCreateSoundCodeLabelResponse) {
	response = &BatchCreateSoundCodeLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
