package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindLicenseProduct invokes the iot.BindLicenseProduct API synchronously
func (client *Client) BindLicenseProduct(request *BindLicenseProductRequest) (response *BindLicenseProductResponse, err error) {
	response = CreateBindLicenseProductResponse()
	err = client.DoAction(request, response)
	return
}

// BindLicenseProductWithChan invokes the iot.BindLicenseProduct API asynchronously
func (client *Client) BindLicenseProductWithChan(request *BindLicenseProductRequest) (<-chan *BindLicenseProductResponse, <-chan error) {
	responseChan := make(chan *BindLicenseProductResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindLicenseProduct(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindLicenseProductWithCallback invokes the iot.BindLicenseProduct API asynchronously
func (client *Client) BindLicenseProductWithCallback(request *BindLicenseProductRequest, callback func(response *BindLicenseProductResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindLicenseProductResponse
		var err error
		defer close(result)
		response, err = client.BindLicenseProduct(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindLicenseProductRequest is the request struct for api BindLicenseProduct
type BindLicenseProductRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	LicenseCode   string `position:"Query" name:"LicenseCode"`
}

// BindLicenseProductResponse is the response struct for api BindLicenseProduct
type BindLicenseProductResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         bool   `json:"Data" xml:"Data"`
}

// CreateBindLicenseProductRequest creates a request to invoke BindLicenseProduct API
func CreateBindLicenseProductRequest() (request *BindLicenseProductRequest) {
	request = &BindLicenseProductRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BindLicenseProduct", "", "")
	request.Method = requests.POST
	return
}

// CreateBindLicenseProductResponse creates a response to parse from BindLicenseProduct response
func CreateBindLicenseProductResponse() (response *BindLicenseProductResponse) {
	response = &BindLicenseProductResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
