package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteParserDataSource invokes the iot.DeleteParserDataSource API synchronously
func (client *Client) DeleteParserDataSource(request *DeleteParserDataSourceRequest) (response *DeleteParserDataSourceResponse, err error) {
	response = CreateDeleteParserDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteParserDataSourceWithChan invokes the iot.DeleteParserDataSource API asynchronously
func (client *Client) DeleteParserDataSourceWithChan(request *DeleteParserDataSourceRequest) (<-chan *DeleteParserDataSourceResponse, <-chan error) {
	responseChan := make(chan *DeleteParserDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteParserDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteParserDataSourceWithCallback invokes the iot.DeleteParserDataSource API asynchronously
func (client *Client) DeleteParserDataSourceWithCallback(request *DeleteParserDataSourceRequest, callback func(response *DeleteParserDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteParserDataSourceResponse
		var err error
		defer close(result)
		response, err = client.DeleteParserDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteParserDataSourceRequest is the request struct for api DeleteParserDataSource
type DeleteParserDataSourceRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	DataSourceId  requests.Integer `position:"Query" name:"DataSourceId"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// DeleteParserDataSourceResponse is the response struct for api DeleteParserDataSource
type DeleteParserDataSourceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteParserDataSourceRequest creates a request to invoke DeleteParserDataSource API
func CreateDeleteParserDataSourceRequest() (request *DeleteParserDataSourceRequest) {
	request = &DeleteParserDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteParserDataSource", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteParserDataSourceResponse creates a response to parse from DeleteParserDataSource response
func CreateDeleteParserDataSourceResponse() (response *DeleteParserDataSourceResponse) {
	response = &DeleteParserDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
