package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachDestination invokes the iot.DetachDestination API synchronously
func (client *Client) DetachDestination(request *DetachDestinationRequest) (response *DetachDestinationResponse, err error) {
	response = CreateDetachDestinationResponse()
	err = client.DoAction(request, response)
	return
}

// DetachDestinationWithChan invokes the iot.DetachDestination API asynchronously
func (client *Client) DetachDestinationWithChan(request *DetachDestinationRequest) (<-chan *DetachDestinationResponse, <-chan error) {
	responseChan := make(chan *DetachDestinationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachDestination(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachDestinationWithCallback invokes the iot.DetachDestination API asynchronously
func (client *Client) DetachDestinationWithCallback(request *DetachDestinationRequest, callback func(response *DetachDestinationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachDestinationResponse
		var err error
		defer close(result)
		response, err = client.DetachDestination(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachDestinationRequest is the request struct for api DetachDestination
type DetachDestinationRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	DestinationId requests.Integer `position:"Query" name:"DestinationId"`
	ParserId      requests.Integer `position:"Query" name:"ParserId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// DetachDestinationResponse is the response struct for api DetachDestination
type DetachDestinationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDetachDestinationRequest creates a request to invoke DetachDestination API
func CreateDetachDestinationRequest() (request *DetachDestinationRequest) {
	request = &DetachDestinationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DetachDestination", "", "")
	request.Method = requests.POST
	return
}

// CreateDetachDestinationResponse creates a response to parse from DetachDestination response
func CreateDetachDestinationResponse() (response *DetachDestinationResponse) {
	response = &DetachDestinationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
