package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachParserDataSource invokes the iot.DetachParserDataSource API synchronously
func (client *Client) DetachParserDataSource(request *DetachParserDataSourceRequest) (response *DetachParserDataSourceResponse, err error) {
	response = CreateDetachParserDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// DetachParserDataSourceWithChan invokes the iot.DetachParserDataSource API asynchronously
func (client *Client) DetachParserDataSourceWithChan(request *DetachParserDataSourceRequest) (<-chan *DetachParserDataSourceResponse, <-chan error) {
	responseChan := make(chan *DetachParserDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachParserDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachParserDataSourceWithCallback invokes the iot.DetachParserDataSource API asynchronously
func (client *Client) DetachParserDataSourceWithCallback(request *DetachParserDataSourceRequest, callback func(response *DetachParserDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachParserDataSourceResponse
		var err error
		defer close(result)
		response, err = client.DetachParserDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachParserDataSourceRequest is the request struct for api DetachParserDataSource
type DetachParserDataSourceRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ParserId      requests.Integer `position:"Query" name:"ParserId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	DataSourceId  requests.Integer `position:"Query" name:"DataSourceId"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// DetachParserDataSourceResponse is the response struct for api DetachParserDataSource
type DetachParserDataSourceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDetachParserDataSourceRequest creates a request to invoke DetachParserDataSource API
func CreateDetachParserDataSourceRequest() (request *DetachParserDataSourceRequest) {
	request = &DetachParserDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DetachParserDataSource", "", "")
	request.Method = requests.POST
	return
}

// CreateDetachParserDataSourceResponse creates a response to parse from DetachParserDataSource response
func CreateDetachParserDataSourceResponse() (response *DetachParserDataSourceResponse) {
	response = &DetachParserDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
