package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSoundCodeSchedule invokes the iot.GetSoundCodeSchedule API synchronously
func (client *Client) GetSoundCodeSchedule(request *GetSoundCodeScheduleRequest) (response *GetSoundCodeScheduleResponse, err error) {
	response = CreateGetSoundCodeScheduleResponse()
	err = client.DoAction(request, response)
	return
}

// GetSoundCodeScheduleWithChan invokes the iot.GetSoundCodeSchedule API asynchronously
func (client *Client) GetSoundCodeScheduleWithChan(request *GetSoundCodeScheduleRequest) (<-chan *GetSoundCodeScheduleResponse, <-chan error) {
	responseChan := make(chan *GetSoundCodeScheduleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSoundCodeSchedule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSoundCodeScheduleWithCallback invokes the iot.GetSoundCodeSchedule API asynchronously
func (client *Client) GetSoundCodeScheduleWithCallback(request *GetSoundCodeScheduleRequest, callback func(response *GetSoundCodeScheduleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSoundCodeScheduleResponse
		var err error
		defer close(result)
		response, err = client.GetSoundCodeSchedule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSoundCodeScheduleRequest is the request struct for api GetSoundCodeSchedule
type GetSoundCodeScheduleRequest struct {
	*requests.RpcRequest
	ScheduleCode  string `position:"Body" name:"ScheduleCode"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// GetSoundCodeScheduleResponse is the response struct for api GetSoundCodeSchedule
type GetSoundCodeScheduleResponse struct {
	*responses.BaseResponse
	RequestId    string                     `json:"RequestId" xml:"RequestId"`
	Success      bool                       `json:"Success" xml:"Success"`
	Code         string                     `json:"Code" xml:"Code"`
	ErrorMessage string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInGetSoundCodeSchedule `json:"Data" xml:"Data"`
}

// CreateGetSoundCodeScheduleRequest creates a request to invoke GetSoundCodeSchedule API
func CreateGetSoundCodeScheduleRequest() (request *GetSoundCodeScheduleRequest) {
	request = &GetSoundCodeScheduleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetSoundCodeSchedule", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSoundCodeScheduleResponse creates a response to parse from GetSoundCodeSchedule response
func CreateGetSoundCodeScheduleResponse() (response *GetSoundCodeScheduleResponse) {
	response = &GetSoundCodeScheduleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
