package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDeviceDesiredProperty invokes the iot.QueryDeviceDesiredProperty API synchronously
func (client *Client) QueryDeviceDesiredProperty(request *QueryDeviceDesiredPropertyRequest) (response *QueryDeviceDesiredPropertyResponse, err error) {
	response = CreateQueryDeviceDesiredPropertyResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDeviceDesiredPropertyWithChan invokes the iot.QueryDeviceDesiredProperty API asynchronously
func (client *Client) QueryDeviceDesiredPropertyWithChan(request *QueryDeviceDesiredPropertyRequest) (<-chan *QueryDeviceDesiredPropertyResponse, <-chan error) {
	responseChan := make(chan *QueryDeviceDesiredPropertyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDeviceDesiredProperty(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDeviceDesiredPropertyWithCallback invokes the iot.QueryDeviceDesiredProperty API asynchronously
func (client *Client) QueryDeviceDesiredPropertyWithCallback(request *QueryDeviceDesiredPropertyRequest, callback func(response *QueryDeviceDesiredPropertyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDeviceDesiredPropertyResponse
		var err error
		defer close(result)
		response, err = client.QueryDeviceDesiredProperty(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDeviceDesiredPropertyRequest is the request struct for api QueryDeviceDesiredProperty
type QueryDeviceDesiredPropertyRequest struct {
	*requests.RpcRequest
	RealTenantId      string    `position:"Query" name:"RealTenantId"`
	RealTripartiteKey string    `position:"Query" name:"RealTripartiteKey"`
	IotId             string    `position:"Query" name:"IotId"`
	IotInstanceId     string    `position:"Query" name:"IotInstanceId"`
	Identifier        *[]string `position:"Query" name:"Identifier"  type:"Repeated"`
	ProductKey        string    `position:"Query" name:"ProductKey"`
	ApiProduct        string    `position:"Body" name:"ApiProduct"`
	ApiRevision       string    `position:"Body" name:"ApiRevision"`
	DeviceName        string    `position:"Query" name:"DeviceName"`
	FunctionBlockId   string    `position:"Query" name:"FunctionBlockId"`
}

// QueryDeviceDesiredPropertyResponse is the response struct for api QueryDeviceDesiredProperty
type QueryDeviceDesiredPropertyResponse struct {
	*responses.BaseResponse
	RequestId    string                           `json:"RequestId" xml:"RequestId"`
	Success      bool                             `json:"Success" xml:"Success"`
	Code         string                           `json:"Code" xml:"Code"`
	ErrorMessage string                           `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryDeviceDesiredProperty `json:"Data" xml:"Data"`
}

// CreateQueryDeviceDesiredPropertyRequest creates a request to invoke QueryDeviceDesiredProperty API
func CreateQueryDeviceDesiredPropertyRequest() (request *QueryDeviceDesiredPropertyRequest) {
	request = &QueryDeviceDesiredPropertyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryDeviceDesiredProperty", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryDeviceDesiredPropertyResponse creates a response to parse from QueryDeviceDesiredProperty response
func CreateQueryDeviceDesiredPropertyResponse() (response *QueryDeviceDesiredPropertyResponse) {
	response = &QueryDeviceDesiredPropertyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
