package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizePictureGeneral invokes the iot.RecognizePictureGeneral API synchronously
func (client *Client) RecognizePictureGeneral(request *RecognizePictureGeneralRequest) (response *RecognizePictureGeneralResponse, err error) {
	response = CreateRecognizePictureGeneralResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizePictureGeneralWithChan invokes the iot.RecognizePictureGeneral API asynchronously
func (client *Client) RecognizePictureGeneralWithChan(request *RecognizePictureGeneralRequest) (<-chan *RecognizePictureGeneralResponse, <-chan error) {
	responseChan := make(chan *RecognizePictureGeneralResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizePictureGeneral(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizePictureGeneralWithCallback invokes the iot.RecognizePictureGeneral API asynchronously
func (client *Client) RecognizePictureGeneralWithCallback(request *RecognizePictureGeneralRequest, callback func(response *RecognizePictureGeneralResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizePictureGeneralResponse
		var err error
		defer close(result)
		response, err = client.RecognizePictureGeneral(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizePictureGeneralRequest is the request struct for api RecognizePictureGeneral
type RecognizePictureGeneralRequest struct {
	*requests.RpcRequest
	Url         string `position:"Query" name:"Url"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// RecognizePictureGeneralResponse is the response struct for api RecognizePictureGeneral
type RecognizePictureGeneralResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateRecognizePictureGeneralRequest creates a request to invoke RecognizePictureGeneral API
func CreateRecognizePictureGeneralRequest() (request *RecognizePictureGeneralRequest) {
	request = &RecognizePictureGeneralRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "RecognizePictureGeneral", "", "")
	request.Method = requests.POST
	return
}

// CreateRecognizePictureGeneralResponse creates a response to parse from RecognizePictureGeneral response
func CreateRecognizePictureGeneralResponse() (response *RecognizePictureGeneralResponse) {
	response = &RecognizePictureGeneralResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
