package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSoundCodeLabel invokes the iot.UpdateSoundCodeLabel API synchronously
func (client *Client) UpdateSoundCodeLabel(request *UpdateSoundCodeLabelRequest) (response *UpdateSoundCodeLabelResponse, err error) {
	response = CreateUpdateSoundCodeLabelResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSoundCodeLabelWithChan invokes the iot.UpdateSoundCodeLabel API asynchronously
func (client *Client) UpdateSoundCodeLabelWithChan(request *UpdateSoundCodeLabelRequest) (<-chan *UpdateSoundCodeLabelResponse, <-chan error) {
	responseChan := make(chan *UpdateSoundCodeLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSoundCodeLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSoundCodeLabelWithCallback invokes the iot.UpdateSoundCodeLabel API asynchronously
func (client *Client) UpdateSoundCodeLabelWithCallback(request *UpdateSoundCodeLabelRequest, callback func(response *UpdateSoundCodeLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSoundCodeLabelResponse
		var err error
		defer close(result)
		response, err = client.UpdateSoundCodeLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSoundCodeLabelRequest is the request struct for api UpdateSoundCodeLabel
type UpdateSoundCodeLabelRequest struct {
	*requests.RpcRequest
	SoundCode     string `position:"Body" name:"SoundCode"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	Label         string `position:"Body" name:"Label"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// UpdateSoundCodeLabelResponse is the response struct for api UpdateSoundCodeLabel
type UpdateSoundCodeLabelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateSoundCodeLabelRequest creates a request to invoke UpdateSoundCodeLabel API
func CreateUpdateSoundCodeLabelRequest() (request *UpdateSoundCodeLabelRequest) {
	request = &UpdateSoundCodeLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateSoundCodeLabel", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateSoundCodeLabelResponse creates a response to parse from UpdateSoundCodeLabel response
func CreateUpdateSoundCodeLabelResponse() (response *UpdateSoundCodeLabelResponse) {
	response = &UpdateSoundCodeLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
