package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitGatewayLocalConfigDeletingTask invokes the linkwan.SubmitGatewayLocalConfigDeletingTask API synchronously
func (client *Client) SubmitGatewayLocalConfigDeletingTask(request *SubmitGatewayLocalConfigDeletingTaskRequest) (response *SubmitGatewayLocalConfigDeletingTaskResponse, err error) {
	response = CreateSubmitGatewayLocalConfigDeletingTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitGatewayLocalConfigDeletingTaskWithChan invokes the linkwan.SubmitGatewayLocalConfigDeletingTask API asynchronously
func (client *Client) SubmitGatewayLocalConfigDeletingTaskWithChan(request *SubmitGatewayLocalConfigDeletingTaskRequest) (<-chan *SubmitGatewayLocalConfigDeletingTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitGatewayLocalConfigDeletingTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitGatewayLocalConfigDeletingTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitGatewayLocalConfigDeletingTaskWithCallback invokes the linkwan.SubmitGatewayLocalConfigDeletingTask API asynchronously
func (client *Client) SubmitGatewayLocalConfigDeletingTaskWithCallback(request *SubmitGatewayLocalConfigDeletingTaskRequest, callback func(response *SubmitGatewayLocalConfigDeletingTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitGatewayLocalConfigDeletingTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitGatewayLocalConfigDeletingTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitGatewayLocalConfigDeletingTaskRequest is the request struct for api SubmitGatewayLocalConfigDeletingTask
type SubmitGatewayLocalConfigDeletingTaskRequest struct {
	*requests.RpcRequest
	GwEui       string `position:"Query" name:"GwEui"`
	D2dAddr     string `position:"Query" name:"D2dAddr"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// SubmitGatewayLocalConfigDeletingTaskResponse is the response struct for api SubmitGatewayLocalConfigDeletingTask
type SubmitGatewayLocalConfigDeletingTaskResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         int64  `json:"Data" xml:"Data"`
}

// CreateSubmitGatewayLocalConfigDeletingTaskRequest creates a request to invoke SubmitGatewayLocalConfigDeletingTask API
func CreateSubmitGatewayLocalConfigDeletingTaskRequest() (request *SubmitGatewayLocalConfigDeletingTaskRequest) {
	request = &SubmitGatewayLocalConfigDeletingTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "SubmitGatewayLocalConfigDeletingTask", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitGatewayLocalConfigDeletingTaskResponse creates a response to parse from SubmitGatewayLocalConfigDeletingTask response
func CreateSubmitGatewayLocalConfigDeletingTaskResponse() (response *SubmitGatewayLocalConfigDeletingTaskResponse) {
	response = &SubmitGatewayLocalConfigDeletingTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
