package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLiveTranscodeTemplate invokes the live.CreateLiveTranscodeTemplate API synchronously
func (client *Client) CreateLiveTranscodeTemplate(request *CreateLiveTranscodeTemplateRequest) (response *CreateLiveTranscodeTemplateResponse, err error) {
	response = CreateCreateLiveTranscodeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLiveTranscodeTemplateWithChan invokes the live.CreateLiveTranscodeTemplate API asynchronously
func (client *Client) CreateLiveTranscodeTemplateWithChan(request *CreateLiveTranscodeTemplateRequest) (<-chan *CreateLiveTranscodeTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateLiveTranscodeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLiveTranscodeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLiveTranscodeTemplateWithCallback invokes the live.CreateLiveTranscodeTemplate API asynchronously
func (client *Client) CreateLiveTranscodeTemplateWithCallback(request *CreateLiveTranscodeTemplateRequest, callback func(response *CreateLiveTranscodeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLiveTranscodeTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateLiveTranscodeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLiveTranscodeTemplateRequest is the request struct for api CreateLiveTranscodeTemplate
type CreateLiveTranscodeTemplateRequest struct {
	*requests.RpcRequest
	Type           string           `position:"Query" name:"Type"`
	SecurityToken  string           `position:"Query" name:"SecurityToken"`
	TemplateConfig string           `position:"Query" name:"TemplateConfig"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateLiveTranscodeTemplateResponse is the response struct for api CreateLiveTranscodeTemplate
type CreateLiveTranscodeTemplateResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TemplateId string `json:"TemplateId" xml:"TemplateId"`
}

// CreateCreateLiveTranscodeTemplateRequest creates a request to invoke CreateLiveTranscodeTemplate API
func CreateCreateLiveTranscodeTemplateRequest() (request *CreateLiveTranscodeTemplateRequest) {
	request = &CreateLiveTranscodeTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateLiveTranscodeTemplate", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLiveTranscodeTemplateResponse creates a response to parse from CreateLiveTranscodeTemplate response
func CreateCreateLiveTranscodeTemplateResponse() (response *CreateLiveTranscodeTemplateResponse) {
	response = &CreateLiveTranscodeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
