package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyGatewayRoute invokes the mse.ApplyGatewayRoute API synchronously
func (client *Client) ApplyGatewayRoute(request *ApplyGatewayRouteRequest) (response *ApplyGatewayRouteResponse, err error) {
	response = CreateApplyGatewayRouteResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyGatewayRouteWithChan invokes the mse.ApplyGatewayRoute API asynchronously
func (client *Client) ApplyGatewayRouteWithChan(request *ApplyGatewayRouteRequest) (<-chan *ApplyGatewayRouteResponse, <-chan error) {
	responseChan := make(chan *ApplyGatewayRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyGatewayRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyGatewayRouteWithCallback invokes the mse.ApplyGatewayRoute API asynchronously
func (client *Client) ApplyGatewayRouteWithCallback(request *ApplyGatewayRouteRequest, callback func(response *ApplyGatewayRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyGatewayRouteResponse
		var err error
		defer close(result)
		response, err = client.ApplyGatewayRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyGatewayRouteRequest is the request struct for api ApplyGatewayRoute
type ApplyGatewayRouteRequest struct {
	*requests.RpcRequest
	MseSessionId    string `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	RouteId         string `position:"Query" name:"RouteId"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// ApplyGatewayRouteResponse is the response struct for api ApplyGatewayRoute
type ApplyGatewayRouteResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateApplyGatewayRouteRequest creates a request to invoke ApplyGatewayRoute API
func CreateApplyGatewayRouteRequest() (request *ApplyGatewayRouteRequest) {
	request = &ApplyGatewayRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ApplyGatewayRoute", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateApplyGatewayRouteResponse creates a response to parse from ApplyGatewayRoute response
func CreateApplyGatewayRouteResponse() (response *ApplyGatewayRouteResponse) {
	response = &ApplyGatewayRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
