package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAuthResource invokes the mse.DeleteAuthResource API synchronously
func (client *Client) DeleteAuthResource(request *DeleteAuthResourceRequest) (response *DeleteAuthResourceResponse, err error) {
	response = CreateDeleteAuthResourceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAuthResourceWithChan invokes the mse.DeleteAuthResource API asynchronously
func (client *Client) DeleteAuthResourceWithChan(request *DeleteAuthResourceRequest) (<-chan *DeleteAuthResourceResponse, <-chan error) {
	responseChan := make(chan *DeleteAuthResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAuthResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAuthResourceWithCallback invokes the mse.DeleteAuthResource API asynchronously
func (client *Client) DeleteAuthResourceWithCallback(request *DeleteAuthResourceRequest, callback func(response *DeleteAuthResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAuthResourceResponse
		var err error
		defer close(result)
		response, err = client.DeleteAuthResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAuthResourceRequest is the request struct for api DeleteAuthResource
type DeleteAuthResourceRequest struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	Id              requests.Integer `position:"Query" name:"Id"`
}

// DeleteAuthResourceResponse is the response struct for api DeleteAuthResource
type DeleteAuthResourceResponse struct {
	*responses.BaseResponse
	RequestId      string                   `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int                      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                   `json:"Message" xml:"Message"`
	Code           int                      `json:"Code" xml:"Code"`
	Success        bool                     `json:"Success" xml:"Success"`
	Data           DataInDeleteAuthResource `json:"Data" xml:"Data"`
}

// CreateDeleteAuthResourceRequest creates a request to invoke DeleteAuthResource API
func CreateDeleteAuthResourceRequest() (request *DeleteAuthResourceRequest) {
	request = &DeleteAuthResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "DeleteAuthResource", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAuthResourceResponse creates a response to parse from DeleteAuthResource response
func CreateDeleteAuthResourceResponse() (response *DeleteAuthResourceResponse) {
	response = &DeleteAuthResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
