package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewayDomain invokes the mse.ListGatewayDomain API synchronously
func (client *Client) ListGatewayDomain(request *ListGatewayDomainRequest) (response *ListGatewayDomainResponse, err error) {
	response = CreateListGatewayDomainResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewayDomainWithChan invokes the mse.ListGatewayDomain API asynchronously
func (client *Client) ListGatewayDomainWithChan(request *ListGatewayDomainRequest) (<-chan *ListGatewayDomainResponse, <-chan error) {
	responseChan := make(chan *ListGatewayDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewayDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewayDomainWithCallback invokes the mse.ListGatewayDomain API asynchronously
func (client *Client) ListGatewayDomainWithCallback(request *ListGatewayDomainRequest, callback func(response *ListGatewayDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewayDomainResponse
		var err error
		defer close(result)
		response, err = client.ListGatewayDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewayDomainRequest is the request struct for api ListGatewayDomain
type ListGatewayDomainRequest struct {
	*requests.RpcRequest
	MseSessionId    string `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	Type            string `position:"Query" name:"Type"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// ListGatewayDomainResponse is the response struct for api ListGatewayDomain
type ListGatewayDomainResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string    `json:"Message" xml:"Message"`
	Code           int       `json:"Code" xml:"Code"`
	Success        bool      `json:"Success" xml:"Success"`
	Data           []Domains `json:"Data" xml:"Data"`
}

// CreateListGatewayDomainRequest creates a request to invoke ListGatewayDomain API
func CreateListGatewayDomainRequest() (request *ListGatewayDomainRequest) {
	request = &ListGatewayDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListGatewayDomain", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewayDomainResponse creates a response to parse from ListGatewayDomain response
func CreateListGatewayDomainResponse() (response *ListGatewayDomainResponse) {
	response = &ListGatewayDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
