package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutClusterHealthCheckTask invokes the mse.PutClusterHealthCheckTask API synchronously
func (client *Client) PutClusterHealthCheckTask(request *PutClusterHealthCheckTaskRequest) (response *PutClusterHealthCheckTaskResponse, err error) {
	response = CreatePutClusterHealthCheckTaskResponse()
	err = client.DoAction(request, response)
	return
}

// PutClusterHealthCheckTaskWithChan invokes the mse.PutClusterHealthCheckTask API asynchronously
func (client *Client) PutClusterHealthCheckTaskWithChan(request *PutClusterHealthCheckTaskRequest) (<-chan *PutClusterHealthCheckTaskResponse, <-chan error) {
	responseChan := make(chan *PutClusterHealthCheckTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutClusterHealthCheckTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutClusterHealthCheckTaskWithCallback invokes the mse.PutClusterHealthCheckTask API asynchronously
func (client *Client) PutClusterHealthCheckTaskWithCallback(request *PutClusterHealthCheckTaskRequest, callback func(response *PutClusterHealthCheckTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutClusterHealthCheckTaskResponse
		var err error
		defer close(result)
		response, err = client.PutClusterHealthCheckTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutClusterHealthCheckTaskRequest is the request struct for api PutClusterHealthCheckTask
type PutClusterHealthCheckTaskRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
}

// PutClusterHealthCheckTaskResponse is the response struct for api PutClusterHealthCheckTask
type PutClusterHealthCheckTaskResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreatePutClusterHealthCheckTaskRequest creates a request to invoke PutClusterHealthCheckTask API
func CreatePutClusterHealthCheckTaskRequest() (request *PutClusterHealthCheckTaskRequest) {
	request = &PutClusterHealthCheckTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "PutClusterHealthCheckTask", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutClusterHealthCheckTaskResponse creates a response to parse from PutClusterHealthCheckTask response
func CreatePutClusterHealthCheckTaskResponse() (response *PutClusterHealthCheckTaskResponse) {
	response = &PutClusterHealthCheckTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
