package nlb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListListeners invokes the nlb.ListListeners API synchronously
func (client *Client) ListListeners(request *ListListenersRequest) (response *ListListenersResponse, err error) {
	response = CreateListListenersResponse()
	err = client.DoAction(request, response)
	return
}

// ListListenersWithChan invokes the nlb.ListListeners API asynchronously
func (client *Client) ListListenersWithChan(request *ListListenersRequest) (<-chan *ListListenersResponse, <-chan error) {
	responseChan := make(chan *ListListenersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListListeners(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListListenersWithCallback invokes the nlb.ListListeners API asynchronously
func (client *Client) ListListenersWithCallback(request *ListListenersRequest, callback func(response *ListListenersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListListenersResponse
		var err error
		defer close(result)
		response, err = client.ListListeners(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListListenersRequest is the request struct for api ListListeners
type ListListenersRequest struct {
	*requests.RpcRequest
	LoadBalancerIds  *[]string        `position:"Query" name:"LoadBalancerIds"  type:"Repeated"`
	NextToken        string           `position:"Query" name:"NextToken"`
	ListenerProtocol string           `position:"Query" name:"ListenerProtocol"`
	ListenerIds      *[]string        `position:"Query" name:"ListenerIds"  type:"Repeated"`
	MaxResults       requests.Integer `position:"Query" name:"MaxResults"`
}

// ListListenersResponse is the response struct for api ListListeners
type ListListenersResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DynamicCode    string         `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string         `json:"DynamicMessage" xml:"DynamicMessage"`
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	NextToken      string         `json:"NextToken" xml:"NextToken"`
	MaxResults     int            `json:"MaxResults" xml:"MaxResults"`
	Listeners      []ListenerInfo `json:"Listeners" xml:"Listeners"`
}

// CreateListListenersRequest creates a request to invoke ListListeners API
func CreateListListenersRequest() (request *ListListenersRequest) {
	request = &ListListenersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Nlb", "2022-04-30", "ListListeners", "nlb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListListenersResponse creates a response to parse from ListListeners response
func CreateListListenersResponse() (response *ListListenersResponse) {
	response = &ListListenersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
