package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDatabases invokes the oceanbasepro.DescribeDatabases API synchronously
func (client *Client) DescribeDatabases(request *DescribeDatabasesRequest) (response *DescribeDatabasesResponse, err error) {
	response = CreateDescribeDatabasesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDatabasesWithChan invokes the oceanbasepro.DescribeDatabases API asynchronously
func (client *Client) DescribeDatabasesWithChan(request *DescribeDatabasesRequest) (<-chan *DescribeDatabasesResponse, <-chan error) {
	responseChan := make(chan *DescribeDatabasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDatabases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDatabasesWithCallback invokes the oceanbasepro.DescribeDatabases API asynchronously
func (client *Client) DescribeDatabasesWithCallback(request *DescribeDatabasesRequest, callback func(response *DescribeDatabasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDatabasesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDatabases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDatabasesRequest is the request struct for api DescribeDatabases
type DescribeDatabasesRequest struct {
	*requests.RpcRequest
	SearchKey    string           `position:"Body" name:"SearchKey"`
	PageNumber   requests.Integer `position:"Body" name:"PageNumber"`
	DatabaseName string           `position:"Body" name:"DatabaseName"`
	WithTables   requests.Boolean `position:"Body" name:"WithTables"`
	TenantId     string           `position:"Body" name:"TenantId"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
}

// DescribeDatabasesResponse is the response struct for api DescribeDatabases
type DescribeDatabasesResponse struct {
	*responses.BaseResponse
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Databases  []Data `json:"Databases" xml:"Databases"`
}

// CreateDescribeDatabasesRequest creates a request to invoke DescribeDatabases API
func CreateDescribeDatabasesRequest() (request *DescribeDatabasesRequest) {
	request = &DescribeDatabasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeDatabases", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDatabasesResponse creates a response to parse from DescribeDatabases response
func CreateDescribeDatabasesResponse() (response *DescribeDatabasesResponse) {
	response = &DescribeDatabasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
