package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOmsOpenAPIProject invokes the oceanbasepro.DescribeOmsOpenAPIProject API synchronously
func (client *Client) DescribeOmsOpenAPIProject(request *DescribeOmsOpenAPIProjectRequest) (response *DescribeOmsOpenAPIProjectResponse, err error) {
	response = CreateDescribeOmsOpenAPIProjectResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOmsOpenAPIProjectWithChan invokes the oceanbasepro.DescribeOmsOpenAPIProject API asynchronously
func (client *Client) DescribeOmsOpenAPIProjectWithChan(request *DescribeOmsOpenAPIProjectRequest) (<-chan *DescribeOmsOpenAPIProjectResponse, <-chan error) {
	responseChan := make(chan *DescribeOmsOpenAPIProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOmsOpenAPIProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOmsOpenAPIProjectWithCallback invokes the oceanbasepro.DescribeOmsOpenAPIProject API asynchronously
func (client *Client) DescribeOmsOpenAPIProjectWithCallback(request *DescribeOmsOpenAPIProjectRequest, callback func(response *DescribeOmsOpenAPIProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOmsOpenAPIProjectResponse
		var err error
		defer close(result)
		response, err = client.DescribeOmsOpenAPIProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOmsOpenAPIProjectRequest is the request struct for api DescribeOmsOpenAPIProject
type DescribeOmsOpenAPIProjectRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	WorkerGradeId string           `position:"Body" name:"WorkerGradeId"`
	ProjectId     string           `position:"Body" name:"ProjectId"`
}

// DescribeOmsOpenAPIProjectResponse is the response struct for api DescribeOmsOpenAPIProject
type DescribeOmsOpenAPIProjectResponse struct {
	*responses.BaseResponse
	Success     bool        `json:"Success" xml:"Success"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	Advice      string      `json:"Advice" xml:"Advice"`
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	TotalCount  int64       `json:"TotalCount" xml:"TotalCount"`
	Cost        string      `json:"Cost" xml:"Cost"`
	ErrorDetail ErrorDetail `json:"ErrorDetail" xml:"ErrorDetail"`
	Data        Data        `json:"Data" xml:"Data"`
}

// CreateDescribeOmsOpenAPIProjectRequest creates a request to invoke DescribeOmsOpenAPIProject API
func CreateDescribeOmsOpenAPIProjectRequest() (request *DescribeOmsOpenAPIProjectRequest) {
	request = &DescribeOmsOpenAPIProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeOmsOpenAPIProject", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeOmsOpenAPIProjectResponse creates a response to parse from DescribeOmsOpenAPIProject response
func CreateDescribeOmsOpenAPIProjectResponse() (response *DescribeOmsOpenAPIProjectResponse) {
	response = &DescribeOmsOpenAPIProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
