package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetReport invokes the pts.GetReport API synchronously
// api document: https://help.aliyun.com/api/pts/getreport.html
func (client *Client) GetReport(request *GetReportRequest) (response *GetReportResponse, err error) {
	response = CreateGetReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetReportWithChan invokes the pts.GetReport API asynchronously
// api document: https://help.aliyun.com/api/pts/getreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetReportWithChan(request *GetReportRequest) (<-chan *GetReportResponse, <-chan error) {
	responseChan := make(chan *GetReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetReportWithCallback invokes the pts.GetReport API asynchronously
// api document: https://help.aliyun.com/api/pts/getreport.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetReportWithCallback(request *GetReportRequest, callback func(response *GetReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetReportResponse
		var err error
		defer close(result)
		response, err = client.GetReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetReportRequest is the request struct for api GetReport
type GetReportRequest struct {
	*requests.RpcRequest
	ReportId requests.Integer `position:"Query" name:"ReportId"`
}

// GetReportResponse is the response struct for api GetReport
type GetReportResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Snapshot  string `json:"Snapshot" xml:"Snapshot"`
	Summary   string `json:"Summary" xml:"Summary"`
}

// CreateGetReportRequest creates a request to invoke GetReport API
func CreateGetReportRequest() (request *GetReportRequest) {
	request = &GetReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2018-11-11", "GetReport", "1.0.0", "openAPI")
	return
}

// CreateGetReportResponse creates a response to parse from GetReport response
func CreateGetReportResponse() (response *GetReportResponse) {
	response = &GetReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
