package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResolverEndpoint invokes the pvtz.DeleteResolverEndpoint API synchronously
func (client *Client) DeleteResolverEndpoint(request *DeleteResolverEndpointRequest) (response *DeleteResolverEndpointResponse, err error) {
	response = CreateDeleteResolverEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResolverEndpointWithChan invokes the pvtz.DeleteResolverEndpoint API asynchronously
func (client *Client) DeleteResolverEndpointWithChan(request *DeleteResolverEndpointRequest) (<-chan *DeleteResolverEndpointResponse, <-chan error) {
	responseChan := make(chan *DeleteResolverEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResolverEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResolverEndpointWithCallback invokes the pvtz.DeleteResolverEndpoint API asynchronously
func (client *Client) DeleteResolverEndpointWithCallback(request *DeleteResolverEndpointRequest, callback func(response *DeleteResolverEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResolverEndpointResponse
		var err error
		defer close(result)
		response, err = client.DeleteResolverEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResolverEndpointRequest is the request struct for api DeleteResolverEndpoint
type DeleteResolverEndpointRequest struct {
	*requests.RpcRequest
	EndpointId   string `position:"Query" name:"EndpointId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DeleteResolverEndpointResponse is the response struct for api DeleteResolverEndpoint
type DeleteResolverEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteResolverEndpointRequest creates a request to invoke DeleteResolverEndpoint API
func CreateDeleteResolverEndpointRequest() (request *DeleteResolverEndpointRequest) {
	request = &DeleteResolverEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DeleteResolverEndpoint", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteResolverEndpointResponse creates a response to parse from DeleteResolverEndpoint response
func CreateDeleteResolverEndpointResponse() (response *DeleteResolverEndpointResponse) {
	response = &DeleteResolverEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
