package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUserInfoByAccount invokes the quickbi_public.QueryUserInfoByAccount API synchronously
func (client *Client) QueryUserInfoByAccount(request *QueryUserInfoByAccountRequest) (response *QueryUserInfoByAccountResponse, err error) {
	response = CreateQueryUserInfoByAccountResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUserInfoByAccountWithChan invokes the quickbi_public.QueryUserInfoByAccount API asynchronously
func (client *Client) QueryUserInfoByAccountWithChan(request *QueryUserInfoByAccountRequest) (<-chan *QueryUserInfoByAccountResponse, <-chan error) {
	responseChan := make(chan *QueryUserInfoByAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUserInfoByAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUserInfoByAccountWithCallback invokes the quickbi_public.QueryUserInfoByAccount API asynchronously
func (client *Client) QueryUserInfoByAccountWithCallback(request *QueryUserInfoByAccountRequest, callback func(response *QueryUserInfoByAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUserInfoByAccountResponse
		var err error
		defer close(result)
		response, err = client.QueryUserInfoByAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUserInfoByAccountRequest is the request struct for api QueryUserInfoByAccount
type QueryUserInfoByAccountRequest struct {
	*requests.RpcRequest
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	AccountType requests.Integer `position:"Query" name:"AccountType"`
	SignType    string           `position:"Query" name:"SignType"`
	Account     string           `position:"Query" name:"Account"`
}

// QueryUserInfoByAccountResponse is the response struct for api QueryUserInfoByAccount
type QueryUserInfoByAccountResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQueryUserInfoByAccountRequest creates a request to invoke QueryUserInfoByAccount API
func CreateQueryUserInfoByAccountRequest() (request *QueryUserInfoByAccountRequest) {
	request = &QueryUserInfoByAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryUserInfoByAccount", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUserInfoByAccountResponse creates a response to parse from QueryUserInfoByAccount response
func CreateQueryUserInfoByAccountResponse() (response *QueryUserInfoByAccountResponse) {
	response = &QueryUserInfoByAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
