package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUserTagMetaList invokes the quickbi_public.QueryUserTagMetaList API synchronously
func (client *Client) QueryUserTagMetaList(request *QueryUserTagMetaListRequest) (response *QueryUserTagMetaListResponse, err error) {
	response = CreateQueryUserTagMetaListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUserTagMetaListWithChan invokes the quickbi_public.QueryUserTagMetaList API asynchronously
func (client *Client) QueryUserTagMetaListWithChan(request *QueryUserTagMetaListRequest) (<-chan *QueryUserTagMetaListResponse, <-chan error) {
	responseChan := make(chan *QueryUserTagMetaListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUserTagMetaList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUserTagMetaListWithCallback invokes the quickbi_public.QueryUserTagMetaList API asynchronously
func (client *Client) QueryUserTagMetaListWithCallback(request *QueryUserTagMetaListRequest, callback func(response *QueryUserTagMetaListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUserTagMetaListResponse
		var err error
		defer close(result)
		response, err = client.QueryUserTagMetaList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUserTagMetaListRequest is the request struct for api QueryUserTagMetaList
type QueryUserTagMetaListRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
}

// QueryUserTagMetaListResponse is the response struct for api QueryUserTagMetaList
type QueryUserTagMetaListResponse struct {
	*responses.BaseResponse
	Success   bool         `json:"Success" xml:"Success"`
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateQueryUserTagMetaListRequest creates a request to invoke QueryUserTagMetaList API
func CreateQueryUserTagMetaListRequest() (request *QueryUserTagMetaListRequest) {
	request = &QueryUserTagMetaListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryUserTagMetaList", "quickbi", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryUserTagMetaListResponse creates a response to parse from QueryUserTagMetaList response
func CreateQueryUserTagMetaListResponse() (response *QueryUserTagMetaListResponse) {
	response = &QueryUserTagMetaListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
