package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEmbeddedStatus invokes the quickbi_public.UpdateEmbeddedStatus API synchronously
func (client *Client) UpdateEmbeddedStatus(request *UpdateEmbeddedStatusRequest) (response *UpdateEmbeddedStatusResponse, err error) {
	response = CreateUpdateEmbeddedStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEmbeddedStatusWithChan invokes the quickbi_public.UpdateEmbeddedStatus API asynchronously
func (client *Client) UpdateEmbeddedStatusWithChan(request *UpdateEmbeddedStatusRequest) (<-chan *UpdateEmbeddedStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateEmbeddedStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEmbeddedStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEmbeddedStatusWithCallback invokes the quickbi_public.UpdateEmbeddedStatus API asynchronously
func (client *Client) UpdateEmbeddedStatusWithCallback(request *UpdateEmbeddedStatusRequest, callback func(response *UpdateEmbeddedStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEmbeddedStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateEmbeddedStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEmbeddedStatusRequest is the request struct for api UpdateEmbeddedStatus
type UpdateEmbeddedStatusRequest struct {
	*requests.RpcRequest
	WorksId           string           `position:"Query" name:"WorksId"`
	ThirdPartAuthFlag requests.Boolean `position:"Query" name:"ThirdPartAuthFlag"`
	AccessPoint       string           `position:"Query" name:"AccessPoint"`
	SignType          string           `position:"Query" name:"SignType"`
}

// UpdateEmbeddedStatusResponse is the response struct for api UpdateEmbeddedStatus
type UpdateEmbeddedStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    int    `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateEmbeddedStatusRequest creates a request to invoke UpdateEmbeddedStatus API
func CreateUpdateEmbeddedStatusRequest() (request *UpdateEmbeddedStatusRequest) {
	request = &UpdateEmbeddedStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "UpdateEmbeddedStatus", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateEmbeddedStatusResponse creates a response to parse from UpdateEmbeddedStatus response
func CreateUpdateEmbeddedStatusResponse() (response *UpdateEmbeddedStatusResponse) {
	response = &UpdateEmbeddedStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
