package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDedicatedUserCluster invokes the r_kvstore.DescribeDedicatedUserCluster API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/describededicatedusercluster.html
func (client *Client) DescribeDedicatedUserCluster(request *DescribeDedicatedUserClusterRequest) (response *DescribeDedicatedUserClusterResponse, err error) {
	response = CreateDescribeDedicatedUserClusterResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDedicatedUserClusterWithChan invokes the r_kvstore.DescribeDedicatedUserCluster API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describededicatedusercluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDedicatedUserClusterWithChan(request *DescribeDedicatedUserClusterRequest) (<-chan *DescribeDedicatedUserClusterResponse, <-chan error) {
	responseChan := make(chan *DescribeDedicatedUserClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDedicatedUserCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDedicatedUserClusterWithCallback invokes the r_kvstore.DescribeDedicatedUserCluster API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/describededicatedusercluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDedicatedUserClusterWithCallback(request *DescribeDedicatedUserClusterRequest, callback func(response *DescribeDedicatedUserClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDedicatedUserClusterResponse
		var err error
		defer close(result)
		response, err = client.DescribeDedicatedUserCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDedicatedUserClusterRequest is the request struct for api DescribeDedicatedUserCluster
type DescribeDedicatedUserClusterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
}

// DescribeDedicatedUserClusterResponse is the response struct for api DescribeDedicatedUserCluster
type DescribeDedicatedUserClusterResponse struct {
	*responses.BaseResponse
	RequestId         string       `json:"RequestId" xml:"RequestId"`
	MaxRecordsPerPage int          `json:"MaxRecordsPerPage" xml:"MaxRecordsPerPage"`
	PageNumber        int          `json:"PageNumber" xml:"PageNumber"`
	TotalRecords      int          `json:"TotalRecords" xml:"TotalRecords"`
	ItemsNumbers      int          `json:"ItemsNumbers" xml:"ItemsNumbers"`
	ClusterItems      ClusterItems `json:"ClusterItems" xml:"ClusterItems"`
}

// CreateDescribeDedicatedUserClusterRequest creates a request to invoke DescribeDedicatedUserCluster API
func CreateDescribeDedicatedUserClusterRequest() (request *DescribeDedicatedUserClusterRequest) {
	request = &DescribeDedicatedUserClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeDedicatedUserCluster", "redisa", "openAPI")
	return
}

// CreateDescribeDedicatedUserClusterResponse creates a response to parse from DescribeDedicatedUserCluster response
func CreateDescribeDedicatedUserClusterResponse() (response *DescribeDedicatedUserClusterResponse) {
	response = &DescribeDedicatedUserClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
