package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVirtualMFADevices invokes the ram.ListVirtualMFADevices API synchronously
func (client *Client) ListVirtualMFADevices(request *ListVirtualMFADevicesRequest) (response *ListVirtualMFADevicesResponse, err error) {
	response = CreateListVirtualMFADevicesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVirtualMFADevicesWithChan invokes the ram.ListVirtualMFADevices API asynchronously
func (client *Client) ListVirtualMFADevicesWithChan(request *ListVirtualMFADevicesRequest) (<-chan *ListVirtualMFADevicesResponse, <-chan error) {
	responseChan := make(chan *ListVirtualMFADevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVirtualMFADevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVirtualMFADevicesWithCallback invokes the ram.ListVirtualMFADevices API asynchronously
func (client *Client) ListVirtualMFADevicesWithCallback(request *ListVirtualMFADevicesRequest, callback func(response *ListVirtualMFADevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVirtualMFADevicesResponse
		var err error
		defer close(result)
		response, err = client.ListVirtualMFADevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVirtualMFADevicesRequest is the request struct for api ListVirtualMFADevices
type ListVirtualMFADevicesRequest struct {
	*requests.RpcRequest
}

// ListVirtualMFADevicesResponse is the response struct for api ListVirtualMFADevices
type ListVirtualMFADevicesResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	VirtualMFADevices VirtualMFADevices `json:"VirtualMFADevices" xml:"VirtualMFADevices"`
}

// CreateListVirtualMFADevicesRequest creates a request to invoke ListVirtualMFADevices API
func CreateListVirtualMFADevicesRequest() (request *ListVirtualMFADevicesRequest) {
	request = &ListVirtualMFADevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "ListVirtualMFADevices", "Ram", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVirtualMFADevicesResponse creates a response to parse from ListVirtualMFADevices response
func CreateListVirtualMFADevicesResponse() (response *ListVirtualMFADevicesResponse) {
	response = &ListVirtualMFADevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
