package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstancePromoteActivity invokes the rds.DescribeDBInstancePromoteActivity API synchronously
func (client *Client) DescribeDBInstancePromoteActivity(request *DescribeDBInstancePromoteActivityRequest) (response *DescribeDBInstancePromoteActivityResponse, err error) {
	response = CreateDescribeDBInstancePromoteActivityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstancePromoteActivityWithChan invokes the rds.DescribeDBInstancePromoteActivity API asynchronously
func (client *Client) DescribeDBInstancePromoteActivityWithChan(request *DescribeDBInstancePromoteActivityRequest) (<-chan *DescribeDBInstancePromoteActivityResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstancePromoteActivityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstancePromoteActivity(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstancePromoteActivityWithCallback invokes the rds.DescribeDBInstancePromoteActivity API asynchronously
func (client *Client) DescribeDBInstancePromoteActivityWithCallback(request *DescribeDBInstancePromoteActivityRequest, callback func(response *DescribeDBInstancePromoteActivityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstancePromoteActivityResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstancePromoteActivity(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstancePromoteActivityRequest is the request struct for api DescribeDBInstancePromoteActivity
type DescribeDBInstancePromoteActivityRequest struct {
	*requests.RpcRequest
	DbInstanceName       string           `position:"Query" name:"DbInstanceName"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	AliUid               string           `position:"Query" name:"AliUid"`
}

// DescribeDBInstancePromoteActivityResponse is the response struct for api DescribeDBInstancePromoteActivity
type DescribeDBInstancePromoteActivityResponse struct {
	*responses.BaseResponse
	DBInstanceName string `json:"DBInstanceName" xml:"DBInstanceName"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	AliUid         string `json:"AliUid" xml:"AliUid"`
	DBType         string `json:"DBType" xml:"DBType"`
	DBInstanceId   string `json:"DBInstanceId" xml:"DBInstanceId"`
	IsActivity     string `json:"IsActivity" xml:"IsActivity"`
	Bid            string `json:"Bid" xml:"Bid"`
}

// CreateDescribeDBInstancePromoteActivityRequest creates a request to invoke DescribeDBInstancePromoteActivity API
func CreateDescribeDBInstancePromoteActivityRequest() (request *DescribeDBInstancePromoteActivityRequest) {
	request = &DescribeDBInstancePromoteActivityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeDBInstancePromoteActivity", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstancePromoteActivityResponse creates a response to parse from DescribeDBInstancePromoteActivity response
func CreateDescribeDBInstancePromoteActivityResponse() (response *DescribeDBInstancePromoteActivityResponse) {
	response = &DescribeDBInstancePromoteActivityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
