package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MigrateConnectionToOtherZone invokes the rds.MigrateConnectionToOtherZone API synchronously
func (client *Client) MigrateConnectionToOtherZone(request *MigrateConnectionToOtherZoneRequest) (response *MigrateConnectionToOtherZoneResponse, err error) {
	response = CreateMigrateConnectionToOtherZoneResponse()
	err = client.DoAction(request, response)
	return
}

// MigrateConnectionToOtherZoneWithChan invokes the rds.MigrateConnectionToOtherZone API asynchronously
func (client *Client) MigrateConnectionToOtherZoneWithChan(request *MigrateConnectionToOtherZoneRequest) (<-chan *MigrateConnectionToOtherZoneResponse, <-chan error) {
	responseChan := make(chan *MigrateConnectionToOtherZoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MigrateConnectionToOtherZone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MigrateConnectionToOtherZoneWithCallback invokes the rds.MigrateConnectionToOtherZone API asynchronously
func (client *Client) MigrateConnectionToOtherZoneWithCallback(request *MigrateConnectionToOtherZoneRequest, callback func(response *MigrateConnectionToOtherZoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MigrateConnectionToOtherZoneResponse
		var err error
		defer close(result)
		response, err = client.MigrateConnectionToOtherZone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MigrateConnectionToOtherZoneRequest is the request struct for api MigrateConnectionToOtherZone
type MigrateConnectionToOtherZoneRequest struct {
	*requests.RpcRequest
	ConnectionString string `position:"Query" name:"ConnectionString"`
	ZoneId           string `position:"Query" name:"ZoneId"`
	DBInstanceId     string `position:"Query" name:"DBInstanceId"`
}

// MigrateConnectionToOtherZoneResponse is the response struct for api MigrateConnectionToOtherZone
type MigrateConnectionToOtherZoneResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMigrateConnectionToOtherZoneRequest creates a request to invoke MigrateConnectionToOtherZone API
func CreateMigrateConnectionToOtherZoneRequest() (request *MigrateConnectionToOtherZoneRequest) {
	request = &MigrateConnectionToOtherZoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "MigrateConnectionToOtherZone", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMigrateConnectionToOtherZoneResponse creates a response to parse from MigrateConnectionToOtherZone response
func CreateMigrateConnectionToOtherZoneResponse() (response *MigrateConnectionToOtherZoneResponse) {
	response = &MigrateConnectionToOtherZoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
