package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAlarmEventList invokes the sas.DescribeAlarmEventList API synchronously
func (client *Client) DescribeAlarmEventList(request *DescribeAlarmEventListRequest) (response *DescribeAlarmEventListResponse, err error) {
	response = CreateDescribeAlarmEventListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAlarmEventListWithChan invokes the sas.DescribeAlarmEventList API asynchronously
func (client *Client) DescribeAlarmEventListWithChan(request *DescribeAlarmEventListRequest) (<-chan *DescribeAlarmEventListResponse, <-chan error) {
	responseChan := make(chan *DescribeAlarmEventListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAlarmEventList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAlarmEventListWithCallback invokes the sas.DescribeAlarmEventList API asynchronously
func (client *Client) DescribeAlarmEventListWithCallback(request *DescribeAlarmEventListRequest, callback func(response *DescribeAlarmEventListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAlarmEventListResponse
		var err error
		defer close(result)
		response, err = client.DescribeAlarmEventList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAlarmEventListRequest is the request struct for api DescribeAlarmEventList
type DescribeAlarmEventListRequest struct {
	*requests.RpcRequest
	TimeEnd              string           `position:"Query" name:"TimeEnd"`
	TargetType           string           `position:"Query" name:"TargetType"`
	AlarmEventType       string           `position:"Query" name:"AlarmEventType"`
	Remark               string           `position:"Query" name:"Remark"`
	ContainerFieldName   string           `position:"Query" name:"ContainerFieldName"`
	AlarmEventName       string           `position:"Query" name:"AlarmEventName"`
	SourceIp             string           `position:"Query" name:"SourceIp"`
	ContainerFieldValue  string           `position:"Query" name:"ContainerFieldValue"`
	PageSize             string           `position:"Query" name:"PageSize"`
	From                 string           `position:"Query" name:"From"`
	Id                   requests.Integer `position:"Query" name:"Id"`
	TacticId             string           `position:"Query" name:"TacticId"`
	Lang                 string           `position:"Query" name:"Lang"`
	UniqueInfo           string           `position:"Query" name:"UniqueInfo"`
	GroupId              string           `position:"Query" name:"GroupId"`
	Dealed               string           `position:"Query" name:"Dealed"`
	CurrentPage          requests.Integer `position:"Query" name:"CurrentPage"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	OperateTimeEnd       string           `position:"Query" name:"OperateTimeEnd"`
	OperateErrorCodeList *[]string        `position:"Query" name:"OperateErrorCodeList"  type:"Repeated"`
	OperateTimeStart     string           `position:"Query" name:"OperateTimeStart"`
	TimeStart            string           `position:"Query" name:"TimeStart"`
	Levels               string           `position:"Query" name:"Levels"`
	Uuids                string           `position:"Query" name:"Uuids"`
}

// DescribeAlarmEventListResponse is the response struct for api DescribeAlarmEventList
type DescribeAlarmEventListResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	PageInfo   PageInfo         `json:"PageInfo" xml:"PageInfo"`
	SuspEvents []SuspEventsItem `json:"SuspEvents" xml:"SuspEvents"`
}

// CreateDescribeAlarmEventListRequest creates a request to invoke DescribeAlarmEventList API
func CreateDescribeAlarmEventListRequest() (request *DescribeAlarmEventListRequest) {
	request = &DescribeAlarmEventListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeAlarmEventList", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAlarmEventListResponse creates a response to parse from DescribeAlarmEventList response
func CreateDescribeAlarmEventListResponse() (response *DescribeAlarmEventListResponse) {
	response = &DescribeAlarmEventListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
