package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHoneyPotAuth invokes the sas.DescribeHoneyPotAuth API synchronously
func (client *Client) DescribeHoneyPotAuth(request *DescribeHoneyPotAuthRequest) (response *DescribeHoneyPotAuthResponse, err error) {
	response = CreateDescribeHoneyPotAuthResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHoneyPotAuthWithChan invokes the sas.DescribeHoneyPotAuth API asynchronously
func (client *Client) DescribeHoneyPotAuthWithChan(request *DescribeHoneyPotAuthRequest) (<-chan *DescribeHoneyPotAuthResponse, <-chan error) {
	responseChan := make(chan *DescribeHoneyPotAuthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHoneyPotAuth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHoneyPotAuthWithCallback invokes the sas.DescribeHoneyPotAuth API asynchronously
func (client *Client) DescribeHoneyPotAuthWithCallback(request *DescribeHoneyPotAuthRequest, callback func(response *DescribeHoneyPotAuthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHoneyPotAuthResponse
		var err error
		defer close(result)
		response, err = client.DescribeHoneyPotAuth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHoneyPotAuthRequest is the request struct for api DescribeHoneyPotAuth
type DescribeHoneyPotAuthRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeHoneyPotAuthResponse is the response struct for api DescribeHoneyPotAuth
type DescribeHoneyPotAuthResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	HoneyPotCount     int    `json:"HoneyPotCount" xml:"HoneyPotCount"`
	HoneyPotAuthCount int64  `json:"HoneyPotAuthCount" xml:"HoneyPotAuthCount"`
}

// CreateDescribeHoneyPotAuthRequest creates a request to invoke DescribeHoneyPotAuth API
func CreateDescribeHoneyPotAuthRequest() (request *DescribeHoneyPotAuthRequest) {
	request = &DescribeHoneyPotAuthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeHoneyPotAuth", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHoneyPotAuthResponse creates a response to parse from DescribeHoneyPotAuth response
func CreateDescribeHoneyPotAuthResponse() (response *DescribeHoneyPotAuthResponse) {
	response = &DescribeHoneyPotAuthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
