package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindAegis invokes the sas.UnbindAegis API synchronously
func (client *Client) UnbindAegis(request *UnbindAegisRequest) (response *UnbindAegisResponse, err error) {
	response = CreateUnbindAegisResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindAegisWithChan invokes the sas.UnbindAegis API asynchronously
func (client *Client) UnbindAegisWithChan(request *UnbindAegisRequest) (<-chan *UnbindAegisResponse, <-chan error) {
	responseChan := make(chan *UnbindAegisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindAegis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindAegisWithCallback invokes the sas.UnbindAegis API asynchronously
func (client *Client) UnbindAegisWithCallback(request *UnbindAegisRequest, callback func(response *UnbindAegisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindAegisResponse
		var err error
		defer close(result)
		response, err = client.UnbindAegis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindAegisRequest is the request struct for api UnbindAegis
type UnbindAegisRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Uuids    string `position:"Query" name:"Uuids"`
}

// UnbindAegisResponse is the response struct for api UnbindAegis
type UnbindAegisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindAegisRequest creates a request to invoke UnbindAegis API
func CreateUnbindAegisRequest() (request *UnbindAegisRequest) {
	request = &UnbindAegisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "UnbindAegis", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnbindAegisResponse creates a response to parse from UnbindAegis response
func CreateUnbindAegisResponse() (response *UnbindAegisResponse) {
	response = &UnbindAegisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
