package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWorkflow invokes the schedulerx2.CreateWorkflow API synchronously
func (client *Client) CreateWorkflow(request *CreateWorkflowRequest) (response *CreateWorkflowResponse, err error) {
	response = CreateCreateWorkflowResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWorkflowWithChan invokes the schedulerx2.CreateWorkflow API asynchronously
func (client *Client) CreateWorkflowWithChan(request *CreateWorkflowRequest) (<-chan *CreateWorkflowResponse, <-chan error) {
	responseChan := make(chan *CreateWorkflowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWorkflow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWorkflowWithCallback invokes the schedulerx2.CreateWorkflow API asynchronously
func (client *Client) CreateWorkflowWithCallback(request *CreateWorkflowRequest, callback func(response *CreateWorkflowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWorkflowResponse
		var err error
		defer close(result)
		response, err = client.CreateWorkflow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWorkflowRequest is the request struct for api CreateWorkflow
type CreateWorkflowRequest struct {
	*requests.RpcRequest
	NamespaceSource string           `position:"Body" name:"NamespaceSource"`
	Timezone        string           `position:"Body" name:"Timezone"`
	Description     string           `position:"Body" name:"Description"`
	GroupId         string           `position:"Body" name:"GroupId"`
	TimeExpression  string           `position:"Body" name:"TimeExpression"`
	Namespace       string           `position:"Body" name:"Namespace"`
	Name            string           `position:"Body" name:"Name"`
	MaxConcurrency  requests.Integer `position:"Body" name:"MaxConcurrency"`
	TimeType        requests.Integer `position:"Body" name:"TimeType"`
}

// CreateWorkflowResponse is the response struct for api CreateWorkflow
type CreateWorkflowResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateWorkflowRequest creates a request to invoke CreateWorkflow API
func CreateCreateWorkflowRequest() (request *CreateWorkflowRequest) {
	request = &CreateWorkflowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "CreateWorkflow", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateWorkflowResponse creates a response to parse from CreateWorkflow response
func CreateCreateWorkflowResponse() (response *CreateWorkflowResponse) {
	response = &CreateWorkflowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
