package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOuterCallCenterData invokes the scsp.CreateOuterCallCenterData API synchronously
func (client *Client) CreateOuterCallCenterData(request *CreateOuterCallCenterDataRequest) (response *CreateOuterCallCenterDataResponse, err error) {
	response = CreateCreateOuterCallCenterDataResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOuterCallCenterDataWithChan invokes the scsp.CreateOuterCallCenterData API asynchronously
func (client *Client) CreateOuterCallCenterDataWithChan(request *CreateOuterCallCenterDataRequest) (<-chan *CreateOuterCallCenterDataResponse, <-chan error) {
	responseChan := make(chan *CreateOuterCallCenterDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOuterCallCenterData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOuterCallCenterDataWithCallback invokes the scsp.CreateOuterCallCenterData API asynchronously
func (client *Client) CreateOuterCallCenterDataWithCallback(request *CreateOuterCallCenterDataRequest, callback func(response *CreateOuterCallCenterDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOuterCallCenterDataResponse
		var err error
		defer close(result)
		response, err = client.CreateOuterCallCenterData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOuterCallCenterDataRequest is the request struct for api CreateOuterCallCenterData
type CreateOuterCallCenterDataRequest struct {
	*requests.RpcRequest
	ExtInfo       string `position:"Body"`
	RecordUrl     string `position:"Body"`
	EndReason     string `position:"Body"`
	SessionId     string `position:"Body"`
	FromPhoneNum  string `position:"Body"`
	InterveneTime string `position:"Body"`
	BizType       string `position:"Body"`
	InstanceId    string `position:"Body"`
	ToPhoneNum    string `position:"Body"`
	BizId         string `position:"Body"`
	TenantId      string `position:"Body"`
	CallType      string `position:"Body"`
	UserInfo      string `position:"Body"`
}

// CreateOuterCallCenterDataResponse is the response struct for api CreateOuterCallCenterData
type CreateOuterCallCenterDataResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateCreateOuterCallCenterDataRequest creates a request to invoke CreateOuterCallCenterData API
func CreateCreateOuterCallCenterDataRequest() (request *CreateOuterCallCenterDataRequest) {
	request = &CreateOuterCallCenterDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "CreateOuterCallCenterData", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateOuterCallCenterDataResponse creates a response to parse from CreateOuterCallCenterData response
func CreateCreateOuterCallCenterDataResponse() (response *CreateOuterCallCenterDataResponse) {
	response = &CreateOuterCallCenterDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
