package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// HangupThirdCall invokes the scsp.HangupThirdCall API synchronously
func (client *Client) HangupThirdCall(request *HangupThirdCallRequest) (response *HangupThirdCallResponse, err error) {
	response = CreateHangupThirdCallResponse()
	err = client.DoAction(request, response)
	return
}

// HangupThirdCallWithChan invokes the scsp.HangupThirdCall API asynchronously
func (client *Client) HangupThirdCallWithChan(request *HangupThirdCallRequest) (<-chan *HangupThirdCallResponse, <-chan error) {
	responseChan := make(chan *HangupThirdCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.HangupThirdCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// HangupThirdCallWithCallback invokes the scsp.HangupThirdCall API asynchronously
func (client *Client) HangupThirdCallWithCallback(request *HangupThirdCallRequest, callback func(response *HangupThirdCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *HangupThirdCallResponse
		var err error
		defer close(result)
		response, err = client.HangupThirdCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// HangupThirdCallRequest is the request struct for api HangupThirdCall
type HangupThirdCallRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Body"`
	InstanceId   string `position:"Body"`
	AccountName  string `position:"Body"`
	CallId       string `position:"Body"`
	JobId        string `position:"Body"`
	ConnectionId string `position:"Body"`
}

// HangupThirdCallResponse is the response struct for api HangupThirdCall
type HangupThirdCallResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateHangupThirdCallRequest creates a request to invoke HangupThirdCall API
func CreateHangupThirdCallRequest() (request *HangupThirdCallRequest) {
	request = &HangupThirdCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "HangupThirdCall", "", "")
	request.Method = requests.POST
	return
}

// CreateHangupThirdCallResponse creates a response to parse from HangupThirdCall response
func CreateHangupThirdCallResponse() (response *HangupThirdCallResponse) {
	response = &HangupThirdCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
