package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateElasticGatewayPrivateZone invokes the sgw.CreateElasticGatewayPrivateZone API synchronously
func (client *Client) CreateElasticGatewayPrivateZone(request *CreateElasticGatewayPrivateZoneRequest) (response *CreateElasticGatewayPrivateZoneResponse, err error) {
	response = CreateCreateElasticGatewayPrivateZoneResponse()
	err = client.DoAction(request, response)
	return
}

// CreateElasticGatewayPrivateZoneWithChan invokes the sgw.CreateElasticGatewayPrivateZone API asynchronously
func (client *Client) CreateElasticGatewayPrivateZoneWithChan(request *CreateElasticGatewayPrivateZoneRequest) (<-chan *CreateElasticGatewayPrivateZoneResponse, <-chan error) {
	responseChan := make(chan *CreateElasticGatewayPrivateZoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateElasticGatewayPrivateZone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateElasticGatewayPrivateZoneWithCallback invokes the sgw.CreateElasticGatewayPrivateZone API asynchronously
func (client *Client) CreateElasticGatewayPrivateZoneWithCallback(request *CreateElasticGatewayPrivateZoneRequest, callback func(response *CreateElasticGatewayPrivateZoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateElasticGatewayPrivateZoneResponse
		var err error
		defer close(result)
		response, err = client.CreateElasticGatewayPrivateZone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateElasticGatewayPrivateZoneRequest is the request struct for api CreateElasticGatewayPrivateZone
type CreateElasticGatewayPrivateZoneRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// CreateElasticGatewayPrivateZoneResponse is the response struct for api CreateElasticGatewayPrivateZone
type CreateElasticGatewayPrivateZoneResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateCreateElasticGatewayPrivateZoneRequest creates a request to invoke CreateElasticGatewayPrivateZone API
func CreateCreateElasticGatewayPrivateZoneRequest() (request *CreateElasticGatewayPrivateZoneRequest) {
	request = &CreateElasticGatewayPrivateZoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CreateElasticGatewayPrivateZone", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateElasticGatewayPrivateZoneResponse creates a response to parse from CreateElasticGatewayPrivateZone response
func CreateCreateElasticGatewayPrivateZoneResponse() (response *CreateElasticGatewayPrivateZoneResponse) {
	response = &CreateElasticGatewayPrivateZoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
