package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagWanList invokes the smartag.DescribeSagWanList API synchronously
func (client *Client) DescribeSagWanList(request *DescribeSagWanListRequest) (response *DescribeSagWanListResponse, err error) {
	response = CreateDescribeSagWanListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagWanListWithChan invokes the smartag.DescribeSagWanList API asynchronously
func (client *Client) DescribeSagWanListWithChan(request *DescribeSagWanListRequest) (<-chan *DescribeSagWanListResponse, <-chan error) {
	responseChan := make(chan *DescribeSagWanListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagWanList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagWanListWithCallback invokes the smartag.DescribeSagWanList API asynchronously
func (client *Client) DescribeSagWanListWithCallback(request *DescribeSagWanListRequest, callback func(response *DescribeSagWanListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagWanListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagWanList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagWanListRequest is the request struct for api DescribeSagWanList
type DescribeSagWanListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// DescribeSagWanListResponse is the response struct for api DescribeSagWanList
type DescribeSagWanListResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Wans       []Wan       `json:"Wans" xml:"Wans"`
	TaskStates []TaskState `json:"TaskStates" xml:"TaskStates"`
}

// CreateDescribeSagWanListRequest creates a request to invoke DescribeSagWanList API
func CreateDescribeSagWanListRequest() (request *DescribeSagWanListRequest) {
	request = &DescribeSagWanListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagWanList", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSagWanListResponse creates a response to parse from DescribeSagWanList response
func CreateDescribeSagWanListResponse() (response *DescribeSagWanListResponse) {
	response = &DescribeSagWanListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
