package smc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopReplicationJob invokes the smc.StopReplicationJob API synchronously
func (client *Client) StopReplicationJob(request *StopReplicationJobRequest) (response *StopReplicationJobResponse, err error) {
	response = CreateStopReplicationJobResponse()
	err = client.DoAction(request, response)
	return
}

// StopReplicationJobWithChan invokes the smc.StopReplicationJob API asynchronously
func (client *Client) StopReplicationJobWithChan(request *StopReplicationJobRequest) (<-chan *StopReplicationJobResponse, <-chan error) {
	responseChan := make(chan *StopReplicationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopReplicationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopReplicationJobWithCallback invokes the smc.StopReplicationJob API asynchronously
func (client *Client) StopReplicationJobWithCallback(request *StopReplicationJobRequest, callback func(response *StopReplicationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopReplicationJobResponse
		var err error
		defer close(result)
		response, err = client.StopReplicationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopReplicationJobRequest is the request struct for api StopReplicationJob
type StopReplicationJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	JobId                string           `position:"Query" name:"JobId"`
}

// StopReplicationJobResponse is the response struct for api StopReplicationJob
type StopReplicationJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopReplicationJobRequest creates a request to invoke StopReplicationJob API
func CreateStopReplicationJobRequest() (request *StopReplicationJobRequest) {
	request = &StopReplicationJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("smc", "2019-06-01", "StopReplicationJob", "smc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopReplicationJobResponse creates a response to parse from StopReplicationJob response
func CreateStopReplicationJobResponse() (response *StopReplicationJobResponse) {
	response = &StopReplicationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
