package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EndUnionTask invokes the unimkt.EndUnionTask API synchronously
func (client *Client) EndUnionTask(request *EndUnionTaskRequest) (response *EndUnionTaskResponse, err error) {
	response = CreateEndUnionTaskResponse()
	err = client.DoAction(request, response)
	return
}

// EndUnionTaskWithChan invokes the unimkt.EndUnionTask API asynchronously
func (client *Client) EndUnionTaskWithChan(request *EndUnionTaskRequest) (<-chan *EndUnionTaskResponse, <-chan error) {
	responseChan := make(chan *EndUnionTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EndUnionTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EndUnionTaskWithCallback invokes the unimkt.EndUnionTask API asynchronously
func (client *Client) EndUnionTaskWithCallback(request *EndUnionTaskRequest, callback func(response *EndUnionTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EndUnionTaskResponse
		var err error
		defer close(result)
		response, err = client.EndUnionTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EndUnionTaskRequest is the request struct for api EndUnionTask
type EndUnionTaskRequest struct {
	*requests.RpcRequest
	ProxyUserId requests.Integer `position:"Query" name:"ProxyUserId"`
	ChannelId   string           `position:"Query" name:"ChannelId"`
	TaskId      requests.Integer `position:"Query" name:"TaskId"`
}

// EndUnionTaskResponse is the response struct for api EndUnionTask
type EndUnionTaskResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateEndUnionTaskRequest creates a request to invoke EndUnionTask API
func CreateEndUnionTaskRequest() (request *EndUnionTaskRequest) {
	request = &EndUnionTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "EndUnionTask", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEndUnionTaskResponse creates a response to parse from EndUnionTask response
func CreateEndUnionTaskResponse() (response *EndUnionTaskResponse) {
	response = &EndUnionTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
