package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVideoSummaryTaskResult invokes the vcs.GetVideoSummaryTaskResult API synchronously
func (client *Client) GetVideoSummaryTaskResult(request *GetVideoSummaryTaskResultRequest) (response *GetVideoSummaryTaskResultResponse, err error) {
	response = CreateGetVideoSummaryTaskResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetVideoSummaryTaskResultWithChan invokes the vcs.GetVideoSummaryTaskResult API asynchronously
func (client *Client) GetVideoSummaryTaskResultWithChan(request *GetVideoSummaryTaskResultRequest) (<-chan *GetVideoSummaryTaskResultResponse, <-chan error) {
	responseChan := make(chan *GetVideoSummaryTaskResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVideoSummaryTaskResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVideoSummaryTaskResultWithCallback invokes the vcs.GetVideoSummaryTaskResult API asynchronously
func (client *Client) GetVideoSummaryTaskResultWithCallback(request *GetVideoSummaryTaskResultRequest, callback func(response *GetVideoSummaryTaskResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVideoSummaryTaskResultResponse
		var err error
		defer close(result)
		response, err = client.GetVideoSummaryTaskResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVideoSummaryTaskResultRequest is the request struct for api GetVideoSummaryTaskResult
type GetVideoSummaryTaskResultRequest struct {
	*requests.RpcRequest
	CorpId string `position:"Body" name:"CorpId"`
	TaskId string `position:"Body" name:"TaskId"`
}

// GetVideoSummaryTaskResultResponse is the response struct for api GetVideoSummaryTaskResult
type GetVideoSummaryTaskResultResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetVideoSummaryTaskResultRequest creates a request to invoke GetVideoSummaryTaskResult API
func CreateGetVideoSummaryTaskResultRequest() (request *GetVideoSummaryTaskResultRequest) {
	request = &GetVideoSummaryTaskResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "GetVideoSummaryTaskResult", "", "")
	request.Method = requests.POST
	return
}

// CreateGetVideoSummaryTaskResultResponse creates a response to parse from GetVideoSummaryTaskResult response
func CreateGetVideoSummaryTaskResultResponse() (response *GetVideoSummaryTaskResultResponse) {
	response = &GetVideoSummaryTaskResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
