package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CustomizeDetectImage invokes the viapi_regen.CustomizeDetectImage API synchronously
func (client *Client) CustomizeDetectImage(request *CustomizeDetectImageRequest) (response *CustomizeDetectImageResponse, err error) {
	response = CreateCustomizeDetectImageResponse()
	err = client.DoAction(request, response)
	return
}

// CustomizeDetectImageWithChan invokes the viapi_regen.CustomizeDetectImage API asynchronously
func (client *Client) CustomizeDetectImageWithChan(request *CustomizeDetectImageRequest) (<-chan *CustomizeDetectImageResponse, <-chan error) {
	responseChan := make(chan *CustomizeDetectImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CustomizeDetectImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CustomizeDetectImageWithCallback invokes the viapi_regen.CustomizeDetectImage API asynchronously
func (client *Client) CustomizeDetectImageWithCallback(request *CustomizeDetectImageRequest, callback func(response *CustomizeDetectImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CustomizeDetectImageResponse
		var err error
		defer close(result)
		response, err = client.CustomizeDetectImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CustomizeDetectImageRequest is the request struct for api CustomizeDetectImage
type CustomizeDetectImageRequest struct {
	*requests.RpcRequest
	ImageUrl  string `position:"Body" name:"ImageUrl"`
	ServiceId string `position:"Body" name:"ServiceId"`
}

// CustomizeDetectImageResponse is the response struct for api CustomizeDetectImage
type CustomizeDetectImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCustomizeDetectImageRequest creates a request to invoke CustomizeDetectImage API
func CreateCustomizeDetectImageRequest() (request *CustomizeDetectImageRequest) {
	request = &CustomizeDetectImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "CustomizeDetectImage", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCustomizeDetectImageResponse creates a response to parse from CustomizeDetectImage response
func CreateCustomizeDetectImageResponse() (response *CustomizeDetectImageResponse) {
	response = &CustomizeDetectImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
